/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import docking.widgets.table.AbstractSortedTableModel;
import docking.widgets.table.TableSortState;
import ghidra.framework.store.Version;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

class VersionHistoryTableModel
extends AbstractSortedTableModel<Version> {
    static final String DATE = "Version Date";
    static final String VERSION = "Version";
    static final String USER = "User";
    static final String COMMENTS = "Comments";
    static final int VERSION_COL = 0;
    static final int DATE_COL = 1;
    static final int USER_COL = 2;
    static final int COMMENTS_COL = 3;
    private String[] columnNames = new String[]{"Version", "Version Date", "User", "Comments"};
    private List<Version> versionList = new ArrayList<Version>();

    VersionHistoryTableModel(Version[] versions) {
        for (Version version : versions) {
            this.versionList.add(version);
        }
        this.setDefaultTableSortState(TableSortState.createDefaultSortState((int)0, (boolean)false));
    }

    public String getName() {
        return "Version History";
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 1) {
            return Date.class;
        }
        if (columnIndex == 0) {
            return Integer.class;
        }
        return String.class;
    }

    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    void refresh(Version[] newVersions) {
        ArrayList<Version> newVersionList = new ArrayList<Version>();
        for (Version version : newVersions) {
            newVersionList.add(version);
        }
        this.versionList = newVersionList;
        this.fireTableDataChanged();
    }

    Version getVersionAt(int row) {
        if (row < 0 || row >= this.versionList.size()) {
            return null;
        }
        return this.versionList.get(row);
    }

    public Object getColumnValueForRow(Version version, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return version.getVersion();
            }
            case 1: {
                return new Date(version.getCreateTime());
            }
            case 2: {
                return version.getUser();
            }
            case 3: {
                return version.getComment();
            }
        }
        return null;
    }

    public List<Version> getModelData() {
        return this.versionList;
    }

    public boolean isSortable(int columnIndex) {
        return true;
    }
}

