/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.catacombae.hfsexplorer.FileSystemRecognizer;
import org.catacombae.hfsexplorer.PartitionSystemRecognizer;
import org.catacombae.hfsexplorer.gui.SelectWindowsDevicePanel;
import org.catacombae.hfsexplorer.partitioning.APMPartition;
import org.catacombae.hfsexplorer.partitioning.ApplePartitionMap;
import org.catacombae.hfsexplorer.partitioning.DriverDescriptorRecord;
import org.catacombae.hfsexplorer.partitioning.GPTEntry;
import org.catacombae.hfsexplorer.partitioning.GUIDPartitionTable;
import org.catacombae.hfsexplorer.partitioning.MBRPartition;
import org.catacombae.hfsexplorer.partitioning.MBRPartitionTable;
import org.catacombae.hfsexplorer.partitioning.Partition;
import org.catacombae.hfsexplorer.partitioning.PartitionSystem;
import org.catacombae.hfsexplorer.win32.WindowsLowLevelIO;
import org.catacombae.io.ReadableConcatenatedStream;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.jparted.lib.ps.PartitionType;
import org.catacombae.jparted.lib.ps.ebr.EBRPartition;

public class SelectWindowsDeviceDialog
extends JDialog {
    private static final String DEVICE_PREFIX = "\\\\?\\GLOBALROOT\\Device\\";
    private SelectWindowsDevicePanel guiPanel;
    private JButton autodetectButton;
    private JRadioButton selectDeviceButton;
    private JRadioButton specifyDeviceNameButton;
    private JButton loadButton;
    private JButton cancelButton;
    private JTextField specifyDeviceNameField;
    private JComboBox detectedDevicesCombo;
    private ButtonGroup selectSpecifyGroup;
    private ReadableRandomAccessStream result = null;
    private String resultCreatePath = null;
    private String[] detectedDeviceNames;

    public SelectWindowsDeviceDialog(Frame owner, boolean modal, String title) {
        super(owner, modal);
        this.setTitle(title);
        this.guiPanel = new SelectWindowsDevicePanel();
        this.autodetectButton = this.guiPanel.autodetectButton;
        this.selectDeviceButton = this.guiPanel.selectDeviceButton;
        this.specifyDeviceNameButton = this.guiPanel.specifyDeviceNameButton;
        this.loadButton = this.guiPanel.loadButton;
        this.cancelButton = this.guiPanel.cancelButton;
        this.specifyDeviceNameField = this.guiPanel.specifyDeviceNameField;
        this.detectedDevicesCombo = this.guiPanel.detectedDevicesCombo;
        this.selectSpecifyGroup = new ButtonGroup();
        this.selectSpecifyGroup.add(this.selectDeviceButton);
        this.selectSpecifyGroup.add(this.specifyDeviceNameButton);
        this.detectedDevicesCombo.removeAllItems();
        for (String name : this.detectedDeviceNames = this.detectDevices()) {
            this.detectedDevicesCombo.addItem(name);
        }
        if (this.detectedDeviceNames.length > 0) {
            this.detectedDevicesCombo.setSelectedIndex(0);
            this.specifyDeviceNameField.setText(DEVICE_PREFIX + this.detectedDevicesCombo.getSelectedItem().toString());
        }
        this.autodetectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SelectWindowsDeviceDialog.this.autodetectFilesystems();
            }
        });
        this.detectedDevicesCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                if (ie.getStateChange() == 1) {
                    SelectWindowsDeviceDialog.this.specifyDeviceNameField.setText(SelectWindowsDeviceDialog.DEVICE_PREFIX + ie.getItem().toString());
                }
            }
        });
        this.selectDeviceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SelectWindowsDeviceDialog.this.detectedDevicesCombo.setEnabled(true);
                SelectWindowsDeviceDialog.this.specifyDeviceNameField.setEnabled(false);
                SelectWindowsDeviceDialog.this.specifyDeviceNameField.setText(SelectWindowsDeviceDialog.DEVICE_PREFIX + SelectWindowsDeviceDialog.this.detectedDevicesCombo.getSelectedItem().toString());
            }
        });
        this.specifyDeviceNameButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SelectWindowsDeviceDialog.this.detectedDevicesCombo.setEnabled(false);
                SelectWindowsDeviceDialog.this.specifyDeviceNameField.setEnabled(true);
            }
        });
        this.loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SelectWindowsDeviceDialog.this.resultCreatePath = SelectWindowsDeviceDialog.this.specifyDeviceNameField.getText();
                SelectWindowsDeviceDialog.this.result = new WindowsLowLevelIO(SelectWindowsDeviceDialog.this.resultCreatePath);
                SelectWindowsDeviceDialog.this.setVisible(false);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SelectWindowsDeviceDialog.this.setVisible(false);
            }
        });
        this.add((Component)this.guiPanel, "Center");
        this.pack();
        this.setLocationRelativeTo(null);
        this.setResizable(false);
    }

    public ReadableRandomAccessStream getPartitionStream() {
        return this.result;
    }

    public String getPathName() {
        return this.resultCreatePath;
    }

    protected String[] detectDevices() {
        LinkedList<String> activeDeviceNames = new LinkedList<String>();
        int i = 0;
        while (true) {
            boolean anyFound = false;
            int j = 0;
            while (true) {
                try {
                    String currentDevice = "Harddisk" + i + "\\Partition" + j;
                    WindowsLowLevelIO curFile = new WindowsLowLevelIO(DEVICE_PREFIX + currentDevice);
                    curFile.close();
                    activeDeviceNames.addLast(currentDevice);
                    anyFound = true;
                }
                catch (Exception e) {
                    if (j >= 20) break;
                }
                ++j;
            }
            if (!anyFound && i >= 20) break;
            ++i;
        }
        i = 0;
        while (true) {
            try {
                String currentDevice = "CdRom" + i;
                WindowsLowLevelIO curFile = new WindowsLowLevelIO(DEVICE_PREFIX + currentDevice);
                curFile.close();
                activeDeviceNames.addLast(currentDevice);
            }
            catch (Exception e) {
                if (i >= 20) break;
            }
            ++i;
        }
        return activeDeviceNames.toArray(new String[activeDeviceNames.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void autodetectFilesystems() {
        LinkedList<String> plainFileSystems = new LinkedList<String>();
        LinkedList<EmbeddedPartitionEntry> embeddedFileSystems = new LinkedList<EmbeddedPartitionEntry>();
        for (int i = 0; i < this.detectedDeviceNames.length; ++i) {
            String deviceName = this.detectedDeviceNames[i];
            WindowsLowLevelIO llf = null;
            try {
                FileSystemRecognizer fsr;
                llf = new WindowsLowLevelIO(DEVICE_PREFIX + deviceName);
                PartitionSystemRecognizer psr = new PartitionSystemRecognizer(llf);
                PartitionSystemRecognizer.PartitionSystemType pst = psr.detectPartitionSystem();
                boolean fileSystemFound = false;
                if (pst != PartitionSystemRecognizer.PartitionSystemType.NONE_FOUND) {
                    PartitionSystem partSys = psr.getPartitionSystem();
                    Partition[] parts = partSys.getUsedPartitionEntries();
                    for (int j = 0; j < parts.length; ++j) {
                        FileSystemRecognizer fsr2;
                        Partition part = parts[j];
                        PartitionType pt = part.getType();
                        if (pt != PartitionType.APPLE_HFS_CONTAINER && pt != PartitionType.APPLE_HFSX || !(fsr2 = new FileSystemRecognizer(llf, part.getStartOffset())).isTypeSupported(fsr2.detectFileSystem())) continue;
                        fileSystemFound = true;
                        embeddedFileSystems.add(new EmbeddedPartitionEntry(deviceName, j, part));
                    }
                }
                if (!fileSystemFound && deviceName.endsWith("Partition0") && (fsr = new FileSystemRecognizer(llf, 0L)).isTypeSupported(fsr.detectFileSystem())) {
                    plainFileSystems.add(deviceName);
                }
                llf.close();
                continue;
            }
            catch (Exception e) {
                System.out.println("INFO: Non-critical exception while detecting partition system at \"\\\\?\\GLOBALROOT\\Device\\" + deviceName + "\": " + e.toString());
                if (llf == null) continue;
                FileSystemRecognizer fsr = new FileSystemRecognizer(llf, 0L);
                if (fsr.isTypeSupported(fsr.detectFileSystem())) {
                    plainFileSystems.add(deviceName);
                }
                llf.close();
            }
        }
        if (plainFileSystems.size() >= 1 || embeddedFileSystems.size() >= 1) {
            String[] plainStrings = plainFileSystems.toArray(new String[plainFileSystems.size()]);
            String[] embeddedStrings = new String[embeddedFileSystems.size()];
            int i = 0;
            for (EmbeddedPartitionEntry cur : embeddedFileSystems) {
                embeddedStrings[i++] = cur.toString();
            }
            Object[] allOptions = new String[plainStrings.length + embeddedStrings.length];
            for (i = 0; i < plainStrings.length; ++i) {
                allOptions[i] = plainStrings[i];
            }
            for (i = 0; i < embeddedStrings.length; ++i) {
                allOptions[plainStrings.length + i] = embeddedStrings[i];
            }
            Object selectedValue = JOptionPane.showInputDialog(this, "Autodetection complete! Found " + allOptions.length + " HFS+ file systems.\n" + "Please choose which one to load:", "Load HFS+ file system", 3, null, allOptions, allOptions[0]);
            if (selectedValue == null) return;
            int selectedIndex = -1;
            for (i = 0; i < allOptions.length; ++i) {
                if (!selectedValue.equals(allOptions[i])) continue;
                selectedIndex = i;
                break;
            }
            if (selectedIndex == -1) {
                throw new RuntimeException("Internal error!");
            }
            if (selectedIndex >= plainStrings.length) {
                Partition p;
                WindowsLowLevelIO llf;
                EmbeddedPartitionEntry embeddedInfo = (EmbeddedPartitionEntry)embeddedFileSystems.get(selectedIndex -= plainStrings.length);
                if (embeddedInfo == null) {
                    throw new RuntimeException("Internal error again.");
                }
                if (embeddedInfo.partition instanceof APMPartition) {
                    llf = new WindowsLowLevelIO(DEVICE_PREFIX + embeddedInfo.deviceName);
                    DriverDescriptorRecord ddr = new DriverDescriptorRecord(llf, 0L);
                    ApplePartitionMap apm = new ApplePartitionMap(llf, (long)(ddr.getSbBlkSize() * 1), (int)ddr.getSbBlkSize());
                    Partition p2 = apm.getPartitionEntry((int)embeddedInfo.partitionNumber);
                    this.resultCreatePath = DEVICE_PREFIX + selectedValue.toString();
                    this.result = new ReadableConcatenatedStream(llf, p2.getStartOffset(), p2.getLength());
                    this.setVisible(false);
                    return;
                } else if (embeddedInfo.partition instanceof GPTEntry) {
                    llf = new WindowsLowLevelIO(DEVICE_PREFIX + embeddedInfo.deviceName);
                    GUIDPartitionTable gpt = new GUIDPartitionTable(llf, 0);
                    p = gpt.getPartitionEntry((int)embeddedInfo.partitionNumber);
                    this.resultCreatePath = DEVICE_PREFIX + selectedValue.toString();
                    this.result = new ReadableConcatenatedStream(llf, p.getStartOffset(), p.getLength());
                    this.setVisible(false);
                    return;
                } else {
                    if (!(embeddedInfo.partition instanceof MBRPartition)) throw new RuntimeException("Unexpected partition system: " + embeddedInfo.partition.getClass());
                    llf = new WindowsLowLevelIO(DEVICE_PREFIX + embeddedInfo.deviceName);
                    MBRPartitionTable mbt = new MBRPartitionTable(llf, 0);
                    p = mbt.getPartitionEntry((int)embeddedInfo.partitionNumber);
                    this.resultCreatePath = DEVICE_PREFIX + selectedValue.toString();
                    this.result = new ReadableConcatenatedStream(llf, p.getStartOffset(), p.getLength());
                    this.setVisible(false);
                }
                return;
            } else {
                this.resultCreatePath = DEVICE_PREFIX + selectedValue.toString();
                this.result = new WindowsLowLevelIO(this.resultCreatePath);
                this.setVisible(false);
            }
            return;
        } else {
            JOptionPane.showMessageDialog(this, "No HFS+ file systems found...", "Result", 1);
        }
    }

    private static final class EmbeddedPartitionEntry {
        public final String deviceName;
        public final long partitionNumber;
        public final Partition partition;

        public EmbeddedPartitionEntry(String deviceName, long partitionNumber, Partition partition) {
            this.deviceName = deviceName;
            this.partitionNumber = partitionNumber;
            this.partition = partition;
        }

        private String getPartitionSystemString() {
            if (this.partition instanceof APMPartition) {
                return "APM";
            }
            if (this.partition instanceof GPTEntry) {
                return "GPT";
            }
            if (this.partition instanceof EBRPartition) {
                return "EBR";
            }
            if (this.partition instanceof MBRPartition) {
                return "MBR";
            }
            return "Unknown partition system";
        }

        public String toString() {
            return this.deviceName + "[" + this.getPartitionSystemString() + ":Partition" + this.partitionNumber + "]";
        }
    }
}

