/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database.annotproc;

import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import ghidra.util.database.annotproc.DBAnnotatedObjectValidator;
import ghidra.util.database.annotproc.ValidationContext;
import java.lang.annotation.Annotation;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Completion;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

public class DBAnnotatedObjectProcessor
extends AbstractProcessor {
    static final Set<Class<? extends Annotation>> SUPPORTED_ANNOTATIONS = Set.of(DBAnnotatedColumn.class, DBAnnotatedField.class, DBAnnotatedObjectInfo.class);
    private ValidationContext ctx;

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        super.init(env);
        this.ctx = new ValidationContext(env);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        DBAnnotatedObjectValidator validator;
        TypeElement type;
        LinkedHashMap<TypeElement, DBAnnotatedObjectValidator> types = new LinkedHashMap<TypeElement, DBAnnotatedObjectValidator>();
        for (Element element : roundEnv.getElementsAnnotatedWith(DBAnnotatedObjectInfo.class)) {
            TypeElement type2 = (TypeElement)element;
            types.put(type2, new DBAnnotatedObjectValidator(this.ctx, type2));
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(DBAnnotatedField.class)) {
            VariableElement varField = (VariableElement)element;
            type = (TypeElement)element.getEnclosingElement();
            validator = types.computeIfAbsent(type, t -> new DBAnnotatedObjectValidator(this.ctx, type));
            validator.addAnnotatedField(varField);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(DBAnnotatedColumn.class)) {
            VariableElement varColumn = (VariableElement)element;
            type = (TypeElement)element.getEnclosingElement();
            validator = types.computeIfAbsent(type, t -> new DBAnnotatedObjectValidator(this.ctx, type));
            validator.addAnnotatedColumn(varColumn);
        }
        for (DBAnnotatedObjectValidator dBAnnotatedObjectValidator : types.values()) {
            dBAnnotatedObjectValidator.validate();
        }
        return true;
    }

    @Override
    public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotation, ExecutableElement member, String userText) {
        return super.getCompletions(element, annotation, member, userText);
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return SUPPORTED_ANNOTATIONS.stream().map(Class::getCanonicalName).collect(Collectors.toSet());
    }
}

