/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.InstructionAnnotation;
import java.util.ArrayList;
import java.util.List;

public class InlinedFunctionCallsiteExtendedMsSymbol
extends AbstractMsSymbol {
    public static final int PDB_ID = 4445;
    private long pointerToInliner;
    private long pointerToThisBlockEnd;
    private RecordNumber inlineeRecordNumber;
    private long invocationsCount;
    private List<InstructionAnnotation> binaryAnnotationOpcodeList = new ArrayList<InstructionAnnotation>();

    public InlinedFunctionCallsiteExtendedMsSymbol(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.pointerToInliner = reader.parseUnsignedIntVal();
        this.pointerToThisBlockEnd = reader.parseUnsignedIntVal();
        this.inlineeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.ITEM, 32);
        this.invocationsCount = reader.parseUnsignedIntVal();
        while (reader.hasMore()) {
            InstructionAnnotation instruction = new InstructionAnnotation(reader);
            if (instruction.getInstructionCode() == InstructionAnnotation.Opcode.INVALID) continue;
            this.binaryAnnotationOpcodeList.add(instruction);
        }
    }

    @Override
    public int getPdbId() {
        return 4445;
    }

    public long getPointerToInliner() {
        return this.pointerToInliner;
    }

    public long getPointerToThisBlockEnd() {
        return this.pointerToThisBlockEnd;
    }

    public RecordNumber getInlineeRecordNumber() {
        return this.inlineeRecordNumber;
    }

    public long getInvocationsCount() {
        return this.invocationsCount;
    }

    public List<InstructionAnnotation> getBinaryAnnotationOpcodeList() {
        return this.binaryAnnotationOpcodeList;
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(this.getSymbolTypeName());
        builder.append(String.format(": Parent: %08X,  End: %08X, PGO Edge Count: %d, Inlinee: %s\n", this.pointerToInliner, this.pointerToThisBlockEnd, this.invocationsCount, this.pdb.getTypeRecord(this.inlineeRecordNumber)));
        int count = 0;
        for (InstructionAnnotation instruction : this.binaryAnnotationOpcodeList) {
            if (count++ == 4) {
                builder.append("\n");
                count = 0;
            }
            builder.append(instruction);
        }
    }

    @Override
    protected String getSymbolTypeName() {
        return "INLINESITE2";
    }
}

