/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RegisterName;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractDefinedSingleAddressRangeMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.RangeAttribute;

public class EnregisteredFieldOfSymbolDARMsSymbol
extends AbstractDefinedSingleAddressRangeMsSymbol {
    public static final int PDB_ID = 4419;
    private int registerHoldingValueOfSymbol;
    private RegisterName registerName;
    private RangeAttribute rangeAttribute;
    private int offsetInParent;

    public EnregisteredFieldOfSymbolDARMsSymbol(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.registerHoldingValueOfSymbol = reader.parseUnsignedShortVal();
        this.registerName = new RegisterName(pdb, this.registerHoldingValueOfSymbol);
        this.rangeAttribute = new RangeAttribute(reader);
        long fields = reader.parseUnsignedIntVal();
        this.offsetInParent = (int)(fields & 0xFFFL);
        this.parseRangeAndGaps(reader);
    }

    public RegisterName getRegister() {
        return this.registerName;
    }

    public RangeAttribute getRangeAttribute() {
        return this.rangeAttribute;
    }

    public int getOffsetInParent() {
        return this.offsetInParent;
    }

    @Override
    public int getPdbId() {
        return 4419;
    }

    @Override
    protected String getSymbolTypeName() {
        return "DEFRANGE_SUBFIELD_REGISTER";
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(this.getSymbolTypeName());
        builder.append(String.format(": offset at %04X: ", this.offsetInParent));
        builder.append(this.rangeAttribute);
        builder.append(" ");
        builder.append(this.registerName);
        this.emitRangeAndGaps(builder);
    }
}

