/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.ProcessorContext;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.pcode.VarnodeTranslator;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.util.ContextEvaluator;
import ghidra.program.util.OffsetAddressFactory;
import ghidra.util.Msg;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import javax.help.UnsupportedOperationException;
import org.apache.commons.lang3.ArrayUtils;

public class VarnodeContext
implements ProcessorContext {
    protected Stack<Stack<HashMap<Address, Varnode>>> memTraces = new Stack();
    protected Stack<Stack<HashMap<Address, Varnode>>> regTraces = new Stack();
    protected Stack<Stack<HashMap<Address, Varnode>>> uniqueTraces = new Stack();
    protected Stack<HashMap<Varnode, Address>> lastSetSaves = new Stack();
    HashMap<Address, ArrayList<Address>> flowToFromLists = new HashMap();
    HashMap<Address, TraceDepthState> addrStartState = new HashMap();
    HashMap<Address, TraceDepthState> addrEndState = new HashMap();
    protected Stack<HashMap<Address, Varnode>> memoryVals = new Stack();
    protected Stack<HashMap<Address, Varnode>> regVals = new Stack();
    protected Stack<HashMap<Address, Varnode>> uniqueVals = new Stack();
    private HashMap<Address, Varnode> tempVals = new HashMap();
    protected HashMap<Address, Varnode> tempUniqueVals = new HashMap();
    protected boolean keepTempUniqueValues = false;
    protected HashSet<Varnode> clearVals = new HashSet();
    protected HashMap<Varnode, Address> lastSet = new HashMap();
    protected HashMap<Varnode, AddressSet> allLastSet = new HashMap();
    protected Program program;
    protected VarnodeTranslator trans;
    protected Varnode[] retVarnodes = null;
    protected Varnode[] killedVarnodes = null;
    protected Varnode stackVarnode = null;
    protected Register stackReg = null;
    private HashSet<String> validSymbolicStackNames = new HashSet();
    public final Address BAD_ADDRESS;
    public final Varnode BAD_VARNODE;
    private final int BAD_OFFSET_SPACEID;
    static final String SUSPECT_CONST_NAME = "SuspectConst";
    private final int SUSPECT_OFFSET_SPACEID;
    public final Address SUSPECT_ZERO_ADDRESS;
    public final int BAD_SPACE_ID_VALUE;
    Varnode[] byteVarnodes = new Varnode[256];
    protected boolean hitDest = false;
    protected int pointerBitSize;
    protected AddressFactory addrFactory = null;
    protected ProgramContext programContext;
    protected Address currentAddress;
    protected Instruction currentInstruction = null;
    boolean isBE = false;
    boolean recordStartEndState = false;
    public boolean debug = false;
    static final Address[] emptyAddrArr = new Address[0];
    private boolean hitMaxAddressSpaces = false;

    public VarnodeContext(Program program, ProgramContext programContext, ProgramContext spaceProgramContext, boolean recordStartEndState) {
        this.program = program;
        this.isBE = program.getLanguage().isBigEndian();
        this.recordStartEndState = recordStartEndState;
        this.addrFactory = new OffsetAddressFactory(program);
        this.pointerBitSize = program.getDefaultPointerSize() * 8;
        this.BAD_ADDRESS = this.addrFactory.getAddress(this.getAddressSpace("BAD_ADDRESS_SPACE", this.pointerBitSize), 0L);
        this.BAD_SPACE_ID_VALUE = this.BAD_ADDRESS.getAddressSpace().getSpaceID();
        this.BAD_OFFSET_SPACEID = this.getAddressSpace("(Bad Address Offset)", this.pointerBitSize);
        this.BAD_VARNODE = this.createBadVarnode();
        this.SUSPECT_ZERO_ADDRESS = this.addrFactory.getAddress(this.getAddressSpace(SUSPECT_CONST_NAME, this.pointerBitSize), 0L);
        this.SUSPECT_OFFSET_SPACEID = this.SUSPECT_ZERO_ADDRESS.getAddressSpace().getSpaceID();
        this.programContext = programContext;
        this.memoryVals.push(new HashMap());
        this.regVals.push(new HashMap());
        this.uniqueVals.push(new HashMap());
        this.setupValidSymbolicStackNames(program);
        this.trans = new VarnodeTranslator(program);
        Language language = program.getLanguage();
        if (language instanceof SleighLanguage) {
            this.keepTempUniqueValues = ((SleighLanguage)language).numSections() != 0;
        }
    }

    public void setDebug(boolean debugOn) {
        this.debug = debugOn;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setCurrentInstruction(Instruction instr) {
        this.currentInstruction = instr;
    }

    public Instruction getCurrentInstruction(Address addr) {
        if (this.currentInstruction != null) {
            return this.currentInstruction;
        }
        this.currentInstruction = this.program.getListing().getInstructionContaining(addr);
        return this.currentInstruction;
    }

    public Register getBaseContextRegister() {
        return null;
    }

    public Address[] getKnownFlowToAddresses(Address toAddr) {
        ArrayList<Address> arrayList = this.flowToFromLists.get(toAddr);
        if (arrayList == null) {
            return emptyAddrArr;
        }
        return arrayList.toArray(emptyAddrArr);
    }

    public void flowToAddress(Address fromAddr, Address toAddr) {
        this.currentAddress = toAddr = fromAddr.getAddressSpace().getOverlayAddress(toAddr);
        ArrayList<Object> arrayList = this.flowToFromLists.get(toAddr);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.flowToFromLists.put(fromAddr, arrayList);
        }
        arrayList.add(fromAddr);
    }

    public void flowStart(Address toAddr) {
        this.currentAddress = toAddr;
        if (this.recordStartEndState) {
            this.addrStartState.put(toAddr, new TraceDepthState(this.regVals.size(), this.regVals));
            this.regVals.push(new HashMap());
        }
    }

    public void flowEnd(Address address) {
        if (this.recordStartEndState) {
            this.addrEndState.put(address, new TraceDepthState(this.regVals.size(), this.regVals));
        }
        this.currentAddress = null;
    }

    public Varnode[] getReturnVarnode(Function targetFunc) {
        PrototypeModel defaultCallingConvention = this.program.getCompilerSpec().getDefaultCallingConvention();
        if (targetFunc != null) {
            int pointerSize;
            DataType undefinedDataType;
            VariableStorage retStorage;
            Varnode[] varnodes = null;
            if (targetFunc.hasCustomVariableStorage()) {
                Parameter retStorage2 = targetFunc.getReturn();
                varnodes = retStorage2.getVariableStorage().getVarnodes();
                return varnodes;
            }
            PrototypeModel callingConvention = targetFunc.getCallingConvention();
            if (callingConvention != null && callingConvention != defaultCallingConvention && (retStorage = callingConvention.getReturnLocation(undefinedDataType = Undefined.getUndefinedDataType((int)(pointerSize = this.program.getDefaultPointerSize())), this.program)) != null && retStorage.isValid()) {
                return retStorage.getVarnodes();
            }
        }
        if (this.retVarnodes != null) {
            return this.retVarnodes;
        }
        DataType undefDT = Undefined.getUndefinedDataType((int)this.program.getDefaultPointerSize());
        VariableStorage retStore = defaultCallingConvention.getReturnLocation(undefDT, this.program);
        this.retVarnodes = retStore != null && retStore.isValid() ? retStore.getVarnodes() : new Varnode[0];
        return this.retVarnodes;
    }

    public Varnode[] getKilledVarnodes(Function targetFunc) {
        PrototypeModel callingConvention;
        PrototypeModel defaultCallingConvention = this.program.getCompilerSpec().getDefaultCallingConvention();
        if (targetFunc != null && (callingConvention = targetFunc.getCallingConvention()) != null) {
            return callingConvention.getKilledByCallList();
        }
        if (this.killedVarnodes != null) {
            return this.killedVarnodes;
        }
        this.killedVarnodes = defaultCallingConvention.getKilledByCallList();
        Object[] returnVarnodes = this.getReturnVarnode(null);
        ArrayList<Varnode> list = new ArrayList<Varnode>();
        for (Varnode varnode : this.killedVarnodes) {
            if (ArrayUtils.contains((Object[])returnVarnodes, (Object)varnode)) continue;
            list.add(varnode);
        }
        this.killedVarnodes = list.toArray(new Varnode[list.size()]);
        return this.killedVarnodes;
    }

    public Varnode getStackVarnode() {
        if (this.stackVarnode != null) {
            return this.stackVarnode;
        }
        Register stackRegister = this.getStackRegister();
        if (stackRegister == null) {
            return null;
        }
        this.stackVarnode = this.trans.getVarnode(stackRegister);
        return this.stackVarnode;
    }

    private void setupValidSymbolicStackNames(Program program) {
        Register stackRegister = this.getStackRegister();
        if (stackRegister == null) {
            return;
        }
        this.validSymbolicStackNames.add(stackRegister.getName());
        List childRegisters = stackRegister.getChildRegisters();
        for (Register register : childRegisters) {
            this.validSymbolicStackNames.add(register.getName());
        }
    }

    public Register getStackRegister() {
        if (this.stackReg != null) {
            return this.stackReg;
        }
        this.stackReg = this.program.getCompilerSpec().getStackPointer();
        if (this.stackReg == null) {
            return null;
        }
        return this.stackReg;
    }

    public Varnode getValue(Varnode varnode, ContextEvaluator evaluator) {
        if (varnode == null) {
            return null;
        }
        return this.getValue(varnode, false, evaluator);
    }

    public Varnode getValue(Varnode varnode, boolean signed, ContextEvaluator evaluator) {
        Instruction instr;
        Long lval;
        if (varnode == null) {
            return null;
        }
        if (this.isConstant(varnode)) {
            return varnode;
        }
        Varnode rvnode = null;
        if (varnode.isUnique()) {
            rvnode = this.getMemoryValue(this.tempUniqueVals, varnode, signed);
            if (rvnode == null && this.keepTempUniqueValues) {
                rvnode = this.getMemoryValue(this.uniqueVals, 0, varnode, signed);
            }
        } else {
            rvnode = this.getMemoryValue(this.tempVals, varnode, signed);
        }
        if (rvnode != null) {
            if (this.debug) {
                Msg.info((Object)this, (Object)("     Tmp " + String.valueOf(varnode) + "  =  " + String.valueOf(rvnode)));
            }
            if (rvnode.getAddress().equals((Object)this.BAD_ADDRESS)) {
                return null;
            }
            return rvnode;
        }
        if (this.isRegister(varnode)) {
            Varnode value = this.getMemoryValue(this.regVals, 0, varnode, signed);
            if (value != null) {
                int spaceVal = value.getSpace();
                if (value.isConstant()) {
                    long lvalue = value.getOffset();
                    int size = value.getSize();
                    if (value.getOffset() == -1L || value.getOffset() == 0L) {
                        spaceVal = this.SUSPECT_OFFSET_SPACEID;
                        value = this.createVarnode(lvalue, spaceVal, size);
                    } else if (signed) {
                        lvalue = lvalue << 8 * (8 - size) >> 8 * (8 - size);
                        value = this.createVarnode(lvalue, spaceVal, size);
                    }
                }
                rvnode = value;
                if (this.debug) {
                    Register reg = this.trans.getRegister(varnode);
                    String name = reg != null ? reg.getName() : varnode.toString();
                    Msg.info((Object)this, (Object)("  " + name + " = " + this.print(rvnode)));
                }
                if (!rvnode.getAddress().equals((Object)this.BAD_ADDRESS)) {
                    return rvnode;
                }
            }
            return varnode;
        }
        boolean isAddr = varnode.isAddress();
        boolean isSymbolicAddr = this.isSymbolicSpace(varnode.getSpace());
        if (isAddr || isSymbolicAddr) {
            long diff;
            Reference[] refsFrom;
            long varnodeOffset = varnode.getOffset();
            if (isAddr && (varnodeOffset == 0L || varnodeOffset == -1L || varnodeOffset == -1L)) {
                return null;
            }
            Varnode lvalue = this.getMemoryValue(varnode, signed);
            if (lvalue != null) {
                if (this.debug) {
                    Msg.info((Object)this, (Object)("   " + String.valueOf(varnode) + " = " + this.print(lvalue)));
                }
                if (isSymbolicAddr && this.isConstant(lvalue) && (lvalue.getOffset() == 0L || lvalue.getOffset() == -1L)) {
                    return null;
                }
                return lvalue;
            }
            Address addr = varnode.getAddress();
            if (this.currentAddress.getAddressSpace().isOverlaySpace()) {
                addr = this.currentAddress.getAddressSpace().getOverlayAddress(addr);
            }
            if (isSymbolicAddr) {
                return null;
            }
            if (this.program.getListing().getInstructionContaining(addr) != null) {
                this.hitDest = true;
            }
            if ((refsFrom = this.program.getReferenceManager().getReferencesFrom(addr)).length > 0 && refsFrom[0].isExternalReference()) {
                Address external = refsFrom[0].getToAddress();
                return this.createVarnode(external.getOffset(), external.getAddressSpace().getSpaceID(), 0);
            }
            boolean isReadOnly = this.isReadOnly(addr);
            if (!(isReadOnly || !addr.getAddressSpace().equals((Object)this.currentAddress.getAddressSpace()) || (diff = addr.subtract(this.currentAddress)) >= 0L && diff <= 4096L || evaluator == null || evaluator.allowAccess(this, addr))) {
                return null;
            }
            int size = varnode.getSize();
            try {
                long value = 0L;
                switch (size) {
                    case 1: {
                        value = this.program.getMemory().getByte(addr) & 0xFF;
                        break;
                    }
                    case 2: {
                        value = this.program.getMemory().getShort(addr) & 0xFFFF;
                        break;
                    }
                    case 4: {
                        value = this.program.getMemory().getInt(addr) & 0xFFFFFFFF;
                        break;
                    }
                    case 8: {
                        value = this.program.getMemory().getLong(addr);
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                if (value == 0L) {
                    return null;
                }
                if (signed) {
                    value = value << 8 * (8 - size) >> 8 * (8 - size);
                }
                int spaceId = this.SUSPECT_OFFSET_SPACEID;
                if (isReadOnly || evaluator != null && evaluator.allowAccess(this, addr)) {
                    spaceId = 0;
                }
                return this.createVarnode(value, spaceId, size);
            }
            catch (MemoryAccessException memoryAccessException) {
                // empty catch block
            }
        }
        if (evaluator != null && !varnode.isAddress() && (lval = evaluator.unknownValue(this, instr = this.getCurrentInstruction(this.currentAddress), varnode)) == null && !varnode.isUnique()) {
            return varnode;
        }
        return null;
    }

    protected Varnode getMemoryValue(Varnode varnode, boolean signed) {
        return this.getMemoryValue(this.memoryVals, 0, varnode, signed);
    }

    protected Varnode getMemoryValue(List<HashMap<Address, Varnode>> valStore, int backupDepth, Varnode varnode, boolean signed) {
        int size = varnode.getSize();
        Varnode[] split = new Varnode[size];
        Address addr = varnode.getAddress();
        for (int i = 0; i < size; ++i) {
            HashMap<Address, Varnode> stateLayer = null;
            for (int layer = valStore.size() - 1 - backupDepth; layer >= 0 && (stateLayer = valStore.get(layer)) != null; --layer) {
                Varnode value = stateLayer.get(addr.addWrapSpace((long)i));
                if (value != null) {
                    split[i] = value;
                    break;
                }
                stateLayer = null;
            }
            if (stateLayer != null) continue;
            return null;
        }
        long value = 0L;
        Varnode type = split[0];
        int typesize = type.getSize();
        boolean isconst = type.isConstant();
        if (!isconst && typesize != 0 && typesize != size) {
            return null;
        }
        for (int i = 0; i < split.length; ++i) {
            Varnode vb = split[i];
            if (vb.getSpace() != type.getSpace()) {
                return null;
            }
            if (isconst) {
                value |= vb.getOffset() << (this.isBE ? size - i - 1 : i) * 8;
                continue;
            }
            if (type == vb) continue;
            return null;
        }
        if (isconst) {
            if (size != 0) {
                value = !signed ? value : value << (8 - size) * 8 >> (8 - size) * 8;
            }
            return this.createConstantVarnode(value, size);
        }
        if (signed && typesize != 0 && typesize < 8) {
            value = type.getOffset();
            value = value << (8 - size) * 8 >> (8 - size) * 8;
            return this.createVarnode(value, type.getSpace(), type.getSize());
        }
        return type;
    }

    protected Varnode getMemoryValue(HashMap<Address, Varnode> valStore, Varnode varnode, boolean signed) {
        int size = varnode.getSize();
        Varnode[] split = new Varnode[size];
        Address addr = varnode.getAddress();
        for (int i = 0; i < size; ++i) {
            Varnode value = valStore.get(addr.addWrapSpace((long)i));
            if (value == null) {
                return null;
            }
            split[i] = value;
        }
        long value = 0L;
        Varnode type = split[0];
        int typesize = type.getSize();
        boolean isconst = type.isConstant();
        if (!isconst && typesize != 0 && typesize != size) {
            return null;
        }
        for (int i = 0; i < split.length; ++i) {
            Varnode vb = split[i];
            if (vb.getSpace() != type.getSpace()) {
                return null;
            }
            if (isconst) {
                value |= vb.getOffset() << (this.isBE ? size - i - 1 : i) * 8;
                continue;
            }
            if (type == vb) continue;
            return null;
        }
        if (isconst) {
            if (size != 0) {
                value = !signed ? value : value << (8 - size) * 8 >> (8 - size) * 8;
            }
            return this.createConstantVarnode(value, size);
        }
        if (signed && typesize != 0 && typesize < 8) {
            value = type.getOffset();
            value = value << (8 - size) * 8 >> (8 - size) * 8;
            return this.createVarnode(value, type.getSpace(), type.getSize());
        }
        return type;
    }

    protected void putMemoryValue(Varnode out, Varnode value) {
        this.putMemoryValue(this.memoryVals, out, value);
    }

    protected void putMemoryValue(Stack<HashMap<Address, Varnode>> valStore, Varnode out, Varnode value) {
        HashMap<Address, Varnode> top = valStore.peek();
        this.putMemoryValue(top, out, value);
    }

    private void putMemoryValue(HashMap<Address, Varnode> top, Varnode out, Varnode value) {
        int len = out.getSize();
        Address addr = out.getAddress();
        if (len == 1) {
            top.put(addr, value);
            return;
        }
        if (!value.isConstant()) {
            for (int nodeOff = 0; nodeOff < len; ++nodeOff) {
                top.put(addr.addWrapSpace((long)nodeOff), value);
            }
            return;
        }
        Varnode[] split = this.splitToBytes(value, out.getSize());
        for (int nodeOff = 0; nodeOff < len; ++nodeOff) {
            if (split == null) {
                top.put(addr.addWrapSpace((long)nodeOff), this.BAD_VARNODE);
                continue;
            }
            top.put(addr.addWrapSpace((long)nodeOff), split[nodeOff]);
        }
    }

    protected boolean isReadOnly(Address addr) {
        boolean readonly = false;
        MemoryBlock block = this.program.getMemory().getBlock(addr);
        if (block != null) {
            boolean bl = readonly = !block.isWrite();
            if (readonly) {
                ReferenceIterator refIter = this.program.getReferenceManager().getReferencesTo(addr);
                for (int count = 0; refIter.hasNext() && count < 100; ++count) {
                    Reference ref = refIter.next();
                    if (!ref.getReferenceType().isWrite()) continue;
                    readonly = false;
                    break;
                }
            }
        }
        return readonly;
    }

    public Varnode createVarnode(long value, int spaceID, int size) {
        if (spaceID == 0) {
            return this.createConstantVarnode(value, size);
        }
        AddressSpace spc = this.addrFactory.getAddressSpace(spaceID);
        Address addr = null;
        addr = spaceID == this.BAD_SPACE_ID_VALUE || spc == null ? this.BAD_ADDRESS : (spaceID == this.BAD_OFFSET_SPACEID ? spc.getTruncatedAddress(value, true) : spc.getTruncatedAddress(value, true));
        return new Varnode(addr, size);
    }

    public Varnode createConstantVarnode(long value, int size) {
        if (size == 1) {
            byte b = (byte)value;
            int offset = 128;
            Varnode bv = this.byteVarnodes[b + 128];
            if (bv == null) {
                AddressSpace spc = this.addrFactory.getConstantSpace();
                Address addr = spc.getAddress((long)(b & 0xFF));
                this.byteVarnodes[b + 128] = bv = new Varnode(addr, size);
            }
            return bv;
        }
        AddressSpace spc = this.addrFactory.getConstantSpace();
        Address addr = spc.getAddress(value);
        return new Varnode(addr, size);
    }

    public Varnode[] splitToBytes(Varnode v, int len) {
        if (!this.isConstant(v)) {
            return null;
        }
        Varnode[] split = new Varnode[len];
        long value = v.getOffset();
        if (this.isBE) {
            for (int i = 0; i < len; ++i) {
                long subv = value >> i * 8;
                split[len - i - 1] = this.createConstantVarnode(subv, 1);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                long subv = value >> i * 8;
                split[i] = this.createConstantVarnode(subv, 1);
            }
        }
        return split;
    }

    public Varnode createBadVarnode() {
        return new Varnode(this.BAD_ADDRESS, 0);
    }

    public Varnode createVarnode(BigInteger bigVal, BigInteger spaceVal, int size) {
        if (size > 8) {
            return null;
        }
        if (spaceVal == null) {
            return this.createConstantVarnode(bigVal.longValue(), size);
        }
        long spaceID = spaceVal.longValue();
        int intSpaceID = (int)spaceID;
        if ((long)intSpaceID != spaceID) {
            return null;
        }
        return this.createVarnode(bigVal.longValue(), spaceVal.intValue(), size);
    }

    public void putValue(Varnode out, Varnode result, boolean mustClear) {
        if (out == null) {
            return;
        }
        if (result == null) {
            this.putValue(out, this.BAD_VARNODE, false);
            return;
        }
        boolean isSymbolicAddr = this.isSymbolicSpace(out.getSpace());
        if ((out.isAddress() || isSymbolicAddr) && !this.isRegister(out)) {
            if (this.debug) {
                Msg.info((Object)this, (Object)("      " + this.print(out) + " <- " + this.print(result) + " at " + String.valueOf(this.currentAddress)));
            }
            this.addSetVarnodeToLastSetLocations(out, this.currentAddress);
            if (isSymbolicAddr && out.getAddress().getAddressSpace().getSpaceID() == this.BAD_OFFSET_SPACEID) {
                return;
            }
            this.putMemoryValue(out, result);
            return;
        }
        if (result.isUnique()) {
            result = null;
        }
        if (out.isUnique()) {
            if (mustClear) {
                result = null;
            }
            this.putMemoryValue(this.tempUniqueVals, out, result);
        } else {
            if (result != null) {
                if (result.getAddress() == this.BAD_ADDRESS) {
                    String spaceName = out.getAddress().getAddressSpace().getName();
                    Register register = this.getRegister(out);
                    if (this.shouldTrackRegister(register)) {
                        spaceName = register.getName();
                        int newRegSpaceID = this.getAddressSpace(spaceName + "-" + String.valueOf(this.currentAddress), this.currentAddress.getSize());
                        result = this.createVarnode(0L, newRegSpaceID, out.getSize());
                    }
                }
                this.addSetVarnodeToLastSetLocations(out, this.currentAddress);
            }
            this.putMemoryValue(this.tempVals, out, result);
        }
        if (this.debug) {
            Msg.info((Object)this, (Object)("      " + this.print(out) + " <- " + this.print(result) + " at " + String.valueOf(this.currentAddress)));
        }
        if (mustClear) {
            this.clearVals.add(out);
        }
    }

    private boolean shouldTrackRegister(Register register) {
        if (register == null) {
            return false;
        }
        return register.getBitLength() > 8 || register.getParentRegister() != null;
    }

    public boolean readExecutableCode() {
        return this.hitDest;
    }

    public void setReadExecutableCode() {
        this.hitDest = true;
    }

    public void clearReadExecutableCode() {
        this.hitDest = false;
    }

    public void propogateResults(boolean clearContext) {
        for (Varnode node : this.clearVals) {
            Register reg = this.trans.getRegister(node);
            if (reg == null) continue;
            if (this.debug) {
                Msg.info((Object)this, (Object)("      " + reg.getName() + "<- Clear"));
            }
            this.clearRegister(reg);
        }
        this.regVals.peek().putAll(this.tempVals);
        if (this.keepTempUniqueValues) {
            this.uniqueVals.peek().putAll(this.tempUniqueVals);
        }
        if (clearContext) {
            if (!this.keepTempUniqueValues) {
                this.tempUniqueVals = new HashMap();
            }
            this.tempVals = new HashMap();
            this.clearVals = new HashSet();
        }
    }

    public void propogateValue(Register reg, Varnode node, Varnode val, Address address) {
        if (this.debug) {
            Msg.info((Object)this, (Object)("   " + reg.getName() + "<-" + val.toString() + " at " + String.valueOf(this.currentAddress)));
        }
        this.addSetVarnodeToLastSetLocations(node, address);
        this.putMemoryValue(this.regVals, node, val);
        List childRegisters = reg.getChildRegisters();
        for (Register register : childRegisters) {
            if (register.getMinimumByteSize() < this.program.getDefaultPointerSize()) continue;
            node = this.getRegisterVarnode(register);
            this.addSetVarnodeToLastSetLocations(node, address);
        }
    }

    private void addSetVarnodeToLastSetLocations(Varnode node, Address address) {
        this.lastSet.put(node, address);
        AddressSet addressSet = this.allLastSet.get(node);
        if (addressSet == null) {
            addressSet = new AddressSet();
            this.allLastSet.put(node, addressSet);
        }
        addressSet.add(address);
        if (node.isRegister() && node.getSize() <= 8) {
            Register register = this.trans.getRegister(node);
            if (register == null) {
                return;
            }
            Register parentRegister = register.getParentRegister();
            if (parentRegister != null && parentRegister.getBitLength() <= 64) {
                node = this.trans.getVarnode(parentRegister);
                this.addSetVarnodeToLastSetLocations(node, address);
            }
        }
    }

    public Address getLastSetLocation(Register reg, BigInteger bval) {
        Varnode rvar = this.trans.getVarnode(reg);
        Address lastSetAddr = this.lastSet.get(rvar);
        if (lastSetAddr != null) {
            return lastSetAddr;
        }
        AddressSet addressSet = this.allLastSet.get(rvar);
        if (addressSet == null) {
            return lastSetAddr;
        }
        AddressIterator addresses = addressSet.getAddresses(true);
        while (addresses.hasNext()) {
            Address address = addresses.next();
            RegisterValue rval = this.getRegisterValue(reg, Address.NO_ADDRESS, address);
            if (rval == null) continue;
            BigInteger rbval = rval.getUnsignedValue();
            if (bval != null && !bval.equals(rbval)) continue;
            lastSetAddr = address;
            break;
        }
        return lastSetAddr;
    }

    public Address getLastSetLocation(Varnode rvar, BigInteger bval) {
        Address lastSetAddr = this.lastSet.get(rvar);
        if (lastSetAddr != null) {
            return lastSetAddr;
        }
        return lastSetAddr;
    }

    public Varnode getVarnode(int spaceID, long offset, int size) {
        AddressSpace space = this.addrFactory.getAddressSpace(spaceID);
        Address target = space.getTruncatedAddress(offset, true);
        Varnode vt = new Varnode(target, size);
        return vt;
    }

    public Long getConstant(Varnode vnode, ContextEvaluator evaluator) {
        if (vnode == null) {
            return null;
        }
        if (!this.isConstant(vnode)) {
            if (evaluator == null) {
                return null;
            }
            Instruction instr = this.getCurrentInstruction(this.currentAddress);
            Long lval = evaluator.unknownValue(this, instr, vnode);
            if (lval != null) {
                return (long)lval;
            }
            return null;
        }
        return vnode.getOffset();
    }

    public Varnode getVarnode(Varnode space, Varnode offset, int size, ContextEvaluator evaluator) {
        if (offset == null) {
            return null;
        }
        int spaceID = offset.getSpace();
        long valbase = 0L;
        if (this.isRegister(offset)) {
            Register reg = this.trans.getRegister(offset);
            if (reg == null) {
                return null;
            }
            spaceID = this.getAddressSpace(reg.getName(), reg.getBitLength());
            valbase = 0L;
        } else if (offset.isConstant()) {
            valbase = offset.getOffset();
            spaceID = (int)space.getOffset();
        } else if (this.isSuspectConstant(offset)) {
            valbase = offset.getOffset();
            spaceID = (int)space.getOffset();
        } else if (OffsetAddressFactory.isSymbolSpace(spaceID)) {
            if (evaluator == null) {
                return null;
            }
            Instruction instr = this.getCurrentInstruction(this.currentAddress);
            Long lval = evaluator.unknownValue(this, instr, offset);
            valbase = offset.getOffset();
            if (lval != null) {
                spaceID = (int)space.getOffset();
                valbase += lval.longValue();
            }
        } else {
            return null;
        }
        return this.getVarnode(spaceID, valbase, size);
    }

    public Varnode getRegisterVarnodeValue(Register reg, Address fromAddr, Address toAddr, boolean signed) {
        if (reg == null) {
            return null;
        }
        Varnode rvnode = this.trans.getVarnode(reg);
        int backupDepth = 0;
        Stack<HashMap<Address, Varnode>> state = this.regVals;
        TraceDepthState traceDepthState = this.addrStartState.get(toAddr);
        if (traceDepthState != null) {
            state = traceDepthState.state();
            backupDepth = state.size() - traceDepthState.depth();
        }
        Varnode value = this.getMemoryValue(state, backupDepth, rvnode, signed);
        int sizeNeeded = reg.getBitLength() / 8;
        if (value != null && (value.getSize() == sizeNeeded || value.getSize() == 0)) {
            return value;
        }
        return null;
    }

    public Varnode getEndRegisterVarnodeValue(Register reg, Address fromAddr, Address toAddr, boolean signed) {
        if (!this.recordStartEndState) {
            throw new UnsupportedOperationException("Must construct class with recordStartEndState == true");
        }
        if (reg == null) {
            return null;
        }
        Varnode rvnode = this.trans.getVarnode(reg);
        TraceDepthState traceDepthState = this.addrEndState.get(toAddr);
        if (traceDepthState == null) {
            return null;
        }
        Stack<HashMap<Address, Varnode>> state = traceDepthState.state();
        int backupDepth = state.size() - traceDepthState.depth();
        Varnode value = this.getMemoryValue(state, backupDepth, rvnode, signed);
        int sizeNeeded = reg.getBitLength() / 8;
        if (value != null && (value.getSize() == sizeNeeded || value.getSize() == 0)) {
            return value;
        }
        return null;
    }

    protected String print(Varnode rvnode) {
        if (rvnode == null) {
            return "<null>";
        }
        if (rvnode.isRegister()) {
            Register reg = this.trans.getRegister(rvnode);
            return reg == null ? "<bad reg " + rvnode.getOffset() + ">" : reg.getName();
        }
        return rvnode.toString();
    }

    public RegisterValue getRegisterValue(Register reg, Address toAddr) {
        return this.getRegisterValue(reg, Address.NO_ADDRESS, toAddr);
    }

    public RegisterValue getRegisterValue(Register reg, Address fromAddr, Address toAddr) {
        Varnode rvnode = this.getRegisterVarnodeValue(reg, fromAddr, toAddr, false);
        if (rvnode == null) {
            return null;
        }
        int spaceID = rvnode.getSpace();
        if (spaceID != this.addrFactory.getConstantSpace().getSpaceID() && spaceID != this.SUSPECT_OFFSET_SPACEID) {
            return null;
        }
        return new RegisterValue(reg, BigInteger.valueOf(rvnode.getOffset()));
    }

    public AddressRangeIterator getRegisterValueAddressRanges(Register reg) {
        return this.programContext.getRegisterValueAddressRanges(reg);
    }

    public boolean hasValueOverRange(Register reg, BigInteger bval, AddressSet set) {
        return this.programContext.hasValueOverRange(reg, bval, (AddressSetView)set);
    }

    public void copy(Varnode out, Varnode in, boolean mustClearAll, ContextEvaluator evaluator) {
        Varnode val1 = null;
        if (out.equals((Object)in)) {
            return;
        }
        val1 = this.getValue(in, evaluator);
        if (val1 != null && in.getSize() > out.getSize() && this.isConstant(val1)) {
            val1 = this.createVarnode(val1.getOffset(), val1.getSpace(), out.getSize());
        }
        if (!in.isRegister() || !out.isRegister()) {
            this.putValue(out, val1, mustClearAll);
            return;
        }
        if (mustClearAll) {
            this.clearVals.add(out);
        }
        this.putValue(out, val1, mustClearAll);
    }

    public Varnode add(Varnode val1, Varnode val2, ContextEvaluator evaluator) {
        Long val2Const;
        if (val1 == null || val2 == null) {
            return null;
        }
        if (this.isConstant(val1) || val1.isAddress()) {
            Varnode swap = val1;
            val1 = val2;
            val2 = swap;
        }
        int spaceID = val1.getSpace();
        long valbase = 0L;
        if (!this.isRegister(val1) || !val1.equals((Object)val2)) {
            if (this.isRegister(val1)) {
                Long uval;
                Register reg = this.trans.getRegister(val1);
                if (reg == null) {
                    return null;
                }
                spaceID = this.getAddressSpace(reg.getName(), reg.getBitLength());
                valbase = 0L;
                Instruction instr = this.getCurrentInstruction(this.currentAddress);
                if (evaluator != null && (uval = evaluator.unknownValue(this, instr, val1)) != null) {
                    valbase = uval;
                    spaceID = val2.getSpace();
                }
            } else if (val1.getAddress() == this.BAD_ADDRESS) {
                spaceID = this.BAD_OFFSET_SPACEID;
                valbase = 0L;
                instr = this.getCurrentInstruction(this.currentAddress);
                if (evaluator != null && (uval = evaluator.unknownValue(this, instr, val1)) != null) {
                    valbase = uval;
                    spaceID = val2.getSpace();
                }
            } else if (this.isConstant(val1)) {
                valbase = val1.getOffset();
                if (!this.isSuspectConstant(val1)) {
                    spaceID = val2.getSpace();
                }
            } else if (this.isSymbolicSpace(spaceID)) {
                instr = this.getCurrentInstruction(this.currentAddress);
                valbase = val1.getOffset();
                if (evaluator != null && (uval = evaluator.unknownValue(this, instr, val1)) != null) {
                    Register reg2;
                    String spaceName;
                    if (val2.isRegister() && ((spaceName = this.addrFactory.getAddressSpace(spaceID).getName()).equals((reg2 = this.trans.getRegister(val2)).getName()) || spaceName.startsWith(reg2.getName() + "-"))) {
                        return this.createConstantVarnode(valbase += uval * 2L, val1.getSize());
                    }
                    valbase = uval;
                    return this.add(this.createConstantVarnode(valbase, val1.getSize()), val2, evaluator);
                }
            } else {
                return null;
            }
        }
        if ((val2Const = this.getConstant(val2, null)) == null) {
            return null;
        }
        long result = valbase + val2Const & -1L >>> (8 - val1.getSize()) * 8;
        return this.createVarnode(result, spaceID, val1.getSize());
    }

    public Varnode and(Varnode val1, Varnode val2, ContextEvaluator evaluator) {
        Long val2Const;
        if (val1 == null || val2 == null) {
            return null;
        }
        if (val1.equals((Object)val2)) {
            return val1;
        }
        if (this.isConstant(val1) || val1.isAddress()) {
            Varnode swap = val1;
            val1 = val2;
            val2 = swap;
        }
        int spaceID = val1.getSpace();
        long valbase = 0L;
        if (this.isRegister(val1)) {
            Register reg = this.trans.getRegister(val1);
            if (reg == null) {
                return null;
            }
            spaceID = this.getAddressSpace(reg.getName(), reg.getBitLength());
            valbase = 0L;
        } else if (val1.isConstant()) {
            valbase = val1.getOffset();
            if (!this.isSuspectConstant(val1)) {
                spaceID = val2.getSpace();
            }
        } else if (this.isSymbolicSpace(spaceID)) {
            valbase = val1.getOffset();
            if (val2.isConstant()) {
                val2Const = this.getConstant(val2, null);
                if (val2Const == null) {
                    return null;
                }
                if (val2Const >> 1 << 1 != val2Const && val2Const >> 2 << 2 != val2Const) {
                    return null;
                }
            }
        } else {
            if (this.isExternalSpace(spaceID)) {
                return val1;
            }
            return null;
        }
        val2Const = this.getConstant(val2, null);
        if (val2Const == null) {
            return null;
        }
        long result = valbase & val2Const & -1L >>> (8 - val1.getSize()) * 8;
        return this.createVarnode(result, spaceID, val1.getSize());
    }

    public Varnode or(Varnode val1, Varnode val2, ContextEvaluator evaluator) {
        Long val1Const;
        if (val1 == null || val2 == null) {
            return null;
        }
        if (val1.equals((Object)val2)) {
            return val1;
        }
        if (this.isConstant(val1) || val1.isAddress()) {
            Varnode swap = val1;
            val1 = val2;
            val2 = swap;
        }
        int spaceID = val1.getSpace();
        Long val2Const = this.getConstant(val2, null);
        if (val2Const == null) {
            return null;
        }
        if (val2Const == 0L) {
            if (!this.isSuspectConstant(val2)) {
                return val1;
            }
            spaceID = val2.getSpace();
        }
        if ((val1Const = this.getConstant(val1, evaluator)) == null) {
            return null;
        }
        long lresult = val1Const | val2Const;
        return this.createVarnode(lresult, spaceID, val1.getSize());
    }

    public Varnode left(Varnode val1, Varnode val2, ContextEvaluator evaluator) {
        if (val1 == null || val2 == null) {
            return null;
        }
        Long val1Const = this.getConstant(val1, evaluator);
        if (val1Const == null) {
            return null;
        }
        Long val2Const = this.getConstant(val2, evaluator);
        if (val2Const == null) {
            return null;
        }
        long lresult = val1Const << (int)val2Const.longValue();
        Varnode result = this.createVarnode(lresult &= -1L >>> (8 - val1.getSize()) * 8, val1.getSpace(), val1.getSize());
        return result;
    }

    public int getAddressSpace(String name, int bitSize) {
        AddressSpace regSpace = this.addrFactory.getAddressSpace(name);
        if (regSpace == null) {
            int spaceBitSize = bitSize < this.pointerBitSize ? this.pointerBitSize : bitSize;
            regSpace = ((OffsetAddressFactory)this.addrFactory).createNewOffsetSpace(name, spaceBitSize);
        }
        if (regSpace == null) {
            if (!this.hitMaxAddressSpaces) {
                Msg.error((Object)this, (Object)("VarnodeContext: out of address spaces at @" + String.valueOf(this.currentAddress) + " for: " + name));
                this.hitMaxAddressSpaces = true;
            }
            return this.BAD_SPACE_ID_VALUE;
        }
        int spaceID = regSpace.getSpaceID();
        return spaceID;
    }

    public Varnode subtract(Varnode val1, Varnode val2, ContextEvaluator evaluator) {
        Long val2Const;
        if (val1 == null || val2 == null) {
            return null;
        }
        if (val1.equals((Object)val2)) {
            if (this.isBadAddress(val1)) {
                return val1;
            }
            int size = val1.getSize();
            size = size > 0 ? size : 1;
            return this.createVarnode(0L, this.addrFactory.getConstantSpace().getSpaceID(), size);
        }
        int spaceID = val1.getSpace();
        long valbase = 0L;
        if (this.isConstant(val1)) {
            valbase = val1.getOffset();
            if (!this.isSuspectConstant(val1)) {
                spaceID = val2.getSpace();
            }
        } else if (this.isRegister(val1)) {
            Register reg = this.trans.getRegister(val1);
            if (reg == null) {
                return null;
            }
            spaceID = this.getAddressSpace(reg.getName(), reg.getBitLength());
            valbase = 0L;
        } else if (this.isSymbolicSpace(spaceID)) {
            Long uval;
            Instruction instr = this.getCurrentInstruction(this.currentAddress);
            valbase = val1.getOffset();
            if (evaluator != null && (uval = evaluator.unknownValue(this, instr, val1)) != null) {
                valbase = uval;
                return this.add(this.createConstantVarnode(valbase, val1.getSize()), val2, evaluator);
            }
        } else {
            return null;
        }
        if ((val2Const = this.getConstant(val2, null)) == null) {
            return null;
        }
        long result = valbase - val2Const & -1L >>> (8 - val1.getSize()) * 8;
        return this.createVarnode(result, spaceID, val1.getSize());
    }

    public Varnode extendValue(Varnode out, Varnode[] in, boolean signExtend, ContextEvaluator evaluator) {
        Varnode vnodeVal = this.getValue(in[0], signExtend, evaluator);
        if (vnodeVal == null) {
            return null;
        }
        if (this.isConstant(vnodeVal) && in[0].getSize() < out.getSize()) {
            if (vnodeVal.getSize() <= 8) {
                Scalar sVal = new Scalar(8 * vnodeVal.getSize(), vnodeVal.getOffset(), signExtend);
                vnodeVal = this.createVarnode(sVal.getValue(), vnodeVal.getSpace(), out.getSize());
            } else {
                vnodeVal = this.createVarnode(vnodeVal.getOffset(), vnodeVal.getSpace(), out.getSize());
            }
        } else if (vnodeVal.isRegister() && vnodeVal.getSize() < out.getSize()) {
            Register reg = this.getRegister(vnodeVal);
            if (reg == null) {
                return null;
            }
            int spaceID = this.getAddressSpace(reg.getName(), reg.getBitLength());
            vnodeVal = this.createVarnode(0L, spaceID, out.getSize());
        }
        return vnodeVal;
    }

    public void clearRegister(Register reg) {
        if (reg == null) {
            return;
        }
        String spaceName = reg.getName() + "-" + String.valueOf(this.currentAddress);
        int spaceId = this.getAddressSpace(spaceName, reg.getBitLength());
        Varnode registerVarnode = this.getRegisterVarnode(reg);
        this.putMemoryValue(this.regVals, registerVarnode, this.createVarnode(0L, spaceId, registerVarnode.getSize()));
    }

    public Register getRegister(String name) {
        return this.trans.getRegister(name);
    }

    public RegisterValue getRegisterValue(Register register) {
        Varnode regVnode = this.trans.getVarnode(register);
        Varnode value = this.getValue(regVnode, false, null);
        if (value != null && this.isConstant(value)) {
            return new RegisterValue(register, BigInteger.valueOf(value.getOffset()));
        }
        return null;
    }

    public Varnode getRegisterVarnodeValue(Register register) {
        Varnode regVnode = this.trans.getVarnode(register);
        Varnode value = this.getValue(regVnode, false, null);
        return value;
    }

    public Varnode getRegisterVarnode(Register register) {
        return this.trans.getVarnode(register);
    }

    public Register getRegister(Varnode vnode) {
        return this.trans.getRegister(vnode);
    }

    public List<Register> getRegisters() {
        return this.trans.getRegisters();
    }

    public BigInteger getValue(Register register, boolean signed) {
        Varnode regVnode = this.trans.getVarnode(register);
        Varnode value = this.getValue(regVnode, signed, null);
        if (value == null) {
            return null;
        }
        if (this.isConstant(value)) {
            return BigInteger.valueOf(value.getOffset());
        }
        return null;
    }

    public boolean hasValue(Register register) {
        Varnode rvnode = this.getRegisterVarnodeValue(register);
        return rvnode != null;
    }

    public void setRegisterValue(RegisterValue value) {
        this.setValue(value.getRegister(), value.getUnsignedValue());
    }

    public void setValue(Register register, BigInteger value) {
        Varnode regVnode = this.trans.getVarnode(register);
        this.putValue(regVnode, this.createConstantVarnode(value.longValue(), regVnode.getSize()), false);
        this.propogateResults(false);
    }

    public boolean isSymbol(Varnode varnode) {
        if (varnode == null) {
            return false;
        }
        return this.isSymbolicSpace(varnode.getAddress().getAddressSpace());
    }

    public boolean isRegister(Varnode varnode) {
        if (varnode == null) {
            return false;
        }
        return varnode.isRegister() || this.trans.getRegister(varnode) != null;
    }

    public boolean isConstant(Varnode varnode) {
        if (varnode == null) {
            return false;
        }
        if (varnode.isConstant()) {
            return true;
        }
        return this.isSuspectConstant(varnode);
    }

    public boolean isBadAddress(Varnode v) {
        if (v == null) {
            return false;
        }
        return v.getAddress().equals((Object)this.BAD_ADDRESS) || v.getSpace() == this.BAD_OFFSET_SPACEID;
    }

    public boolean isSuspectConstant(Varnode varnode) {
        if (varnode == null) {
            return false;
        }
        return varnode.getSpace() == this.SUSPECT_OFFSET_SPACEID;
    }

    public boolean isStackSymbolicSpace(Varnode varnode) {
        if (varnode == null) {
            return false;
        }
        AddressSpace regSpace = this.addrFactory.getAddressSpace(varnode.getSpace());
        return this.isStackSpaceName(regSpace.getName());
    }

    public boolean isStackSpaceName(String spaceName) {
        return this.validSymbolicStackNames.contains(spaceName);
    }

    public boolean isSymbolicSpace(AddressSpace space) {
        int spaceID = space.getSpaceID();
        return OffsetAddressFactory.isSymbolSpace(spaceID);
    }

    public boolean isSymbolicSpace(int spaceID) {
        return OffsetAddressFactory.isSymbolSpace(spaceID);
    }

    public boolean isExternalSpace(int spaceID) {
        return spaceID == AddressSpace.EXTERNAL_SPACE.getSpaceID();
    }

    public void pushMemState() {
        Stack newRegValsTrace = (Stack)this.regVals.clone();
        this.regTraces.push(newRegValsTrace);
        this.regVals.push(new HashMap());
        Stack newUniqueValsTrace = (Stack)this.uniqueVals.clone();
        this.uniqueTraces.push(newUniqueValsTrace);
        this.uniqueVals.push(new HashMap());
        Stack newMemValsTrace = (Stack)this.memoryVals.clone();
        newMemValsTrace.push(new HashMap());
        this.memTraces.push(newMemValsTrace);
        this.memoryVals.push(new HashMap());
        this.lastSetSaves.push((HashMap)this.lastSet.clone());
    }

    public void popMemState() {
        this.regVals = this.regTraces.pop();
        this.memoryVals = this.memTraces.pop();
        this.uniqueVals = this.uniqueTraces.pop();
        this.lastSet = this.lastSetSaves.pop();
        this.tempVals = new HashMap();
        this.clearVals = new HashSet();
    }

    record TraceDepthState(int depth, Stack<HashMap<Address, Varnode>> state) {
    }
}

