/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.som;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.som.SomAuxHeader;
import ghidra.app.util.bin.format.som.SomAuxHeaderFactory;
import ghidra.app.util.bin.format.som.SomCompilationUnit;
import ghidra.app.util.bin.format.som.SomSpace;
import ghidra.app.util.bin.format.som.SomSubspace;
import ghidra.app.util.bin.format.som.SomSymbol;
import ghidra.app.util.bin.format.som.SomSysClock;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SomHeader
implements StructConverter {
    public static final int SIZE = 128;
    private int systemId;
    private int magic;
    private long versionId;
    private SomSysClock fileTime;
    private long entrySpace;
    private long entrySubspace;
    private long entryOffset;
    private long auxHeaderLocation;
    private long auxHeaderSize;
    private long somLength;
    private long presumedDp;
    private long spaceLocation;
    private long spaceTotal;
    private long subspaceLocation;
    private long subspaceTotal;
    private long loaderFixupLocation;
    private long loaderFixupTotal;
    private long spaceStringsLocation;
    private long spaceStringsSize;
    private long initArrayLocation;
    private long initArrayTotal;
    private long compilerLocation;
    private long compilerTotal;
    private long symbolLocation;
    private long symbolTotal;
    private long fixupRequestLocation;
    private long fixupRequestTotal;
    private long symbolStringsLocation;
    private long symbolStringsSize;
    private long unloadableSpLocation;
    private long unloadableSpSize;
    private long checksum;
    private List<SomSpace> spaces = new ArrayList<SomSpace>();
    private List<SomSubspace> subspaces = new ArrayList<SomSubspace>();
    private List<SomAuxHeader> auxHeaders = new ArrayList<SomAuxHeader>();
    private List<SomCompilationUnit> compilationUnits = new ArrayList<SomCompilationUnit>();
    private List<SomSymbol> symbols = new ArrayList<SomSymbol>();

    public SomHeader(BinaryReader reader) throws IOException {
        int i;
        this.systemId = reader.readNextUnsignedShort();
        this.magic = reader.readNextUnsignedShort();
        this.versionId = reader.readNextUnsignedInt();
        this.fileTime = new SomSysClock(reader);
        this.entrySpace = reader.readNextUnsignedInt();
        this.entrySubspace = reader.readNextUnsignedInt();
        this.entryOffset = reader.readNextUnsignedInt();
        this.auxHeaderLocation = reader.readNextUnsignedInt();
        this.auxHeaderSize = reader.readNextUnsignedInt();
        this.somLength = reader.readNextUnsignedInt();
        this.presumedDp = reader.readNextUnsignedInt();
        this.spaceLocation = reader.readNextUnsignedInt();
        this.spaceTotal = reader.readNextUnsignedInt();
        this.subspaceLocation = reader.readNextUnsignedInt();
        this.subspaceTotal = reader.readNextUnsignedInt();
        this.loaderFixupLocation = reader.readNextUnsignedInt();
        this.loaderFixupTotal = reader.readNextUnsignedInt();
        this.spaceStringsLocation = reader.readNextUnsignedInt();
        this.spaceStringsSize = reader.readNextUnsignedInt();
        this.initArrayLocation = reader.readNextUnsignedInt();
        this.initArrayTotal = reader.readNextUnsignedInt();
        this.compilerLocation = reader.readNextUnsignedInt();
        this.compilerTotal = reader.readNextUnsignedInt();
        this.symbolLocation = reader.readNextUnsignedInt();
        this.symbolTotal = reader.readNextUnsignedInt();
        this.fixupRequestLocation = reader.readNextUnsignedInt();
        this.fixupRequestTotal = reader.readNextUnsignedInt();
        this.symbolStringsLocation = reader.readNextUnsignedInt();
        this.symbolStringsSize = reader.readNextUnsignedInt();
        this.unloadableSpLocation = reader.readNextUnsignedInt();
        this.unloadableSpSize = reader.readNextUnsignedInt();
        this.checksum = reader.readNextUnsignedInt();
        if (this.spaceLocation > 0L) {
            reader.setPointerIndex(this.spaceLocation);
            i = 0;
            while ((long)i < this.spaceTotal) {
                this.spaces.add(new SomSpace(reader, this.spaceStringsLocation));
                ++i;
            }
        }
        if (this.subspaceLocation > 0L) {
            reader.setPointerIndex(this.subspaceLocation);
            i = 0;
            while ((long)i < this.subspaceTotal) {
                this.subspaces.add(new SomSubspace(reader, this.spaceStringsLocation));
                ++i;
            }
        }
        if (this.auxHeaderLocation > 0L) {
            SomAuxHeader auxHeader;
            reader.setPointerIndex(this.auxHeaderLocation);
            for (long sizeRemaining = this.auxHeaderSize; sizeRemaining > 0L; sizeRemaining -= auxHeader.getAuxId().getLength() + 8L) {
                auxHeader = SomAuxHeaderFactory.readNextAuxHeader(reader);
                this.auxHeaders.add(auxHeader);
            }
        }
        if (this.compilerLocation > 0L) {
            reader.setPointerIndex(this.compilerLocation);
            int i2 = 0;
            while ((long)i2 < this.compilerTotal) {
                this.compilationUnits.add(new SomCompilationUnit(reader, this.symbolStringsLocation));
                ++i2;
            }
        }
        if (this.symbolLocation > 0L) {
            reader.setPointerIndex(this.symbolLocation);
            int i3 = 0;
            while ((long)i3 < this.symbolTotal) {
                this.symbols.add(new SomSymbol(reader, this.symbolStringsLocation));
                ++i3;
            }
        }
    }

    public int getSystemId() {
        return this.systemId;
    }

    public int getMagic() {
        return this.magic;
    }

    public boolean hasValidMagic() {
        return switch (this.magic) {
            case 260, 262, 263, 264, 267, 269, 270, 1561 -> true;
            default -> false;
        };
    }

    public long getVersionId() {
        return this.versionId;
    }

    public boolean hasValidVersionId() {
        return this.versionId == 85082112L || this.versionId == 87102412L;
    }

    public SomSysClock getFileType() {
        return this.fileTime;
    }

    public long getEntrySpace() {
        return this.entrySpace;
    }

    public long getEntrySubspace() {
        return this.entrySubspace;
    }

    public long getEntryOffset() {
        return this.entryOffset;
    }

    public long getAuxHeaderLocation() {
        return this.auxHeaderLocation;
    }

    public long getAuxHeaderSize() {
        return this.auxHeaderSize;
    }

    public long getSomLength() {
        return this.somLength;
    }

    public long getPresumedDp() {
        return this.presumedDp;
    }

    public long getSpaceLocation() {
        return this.spaceLocation;
    }

    public long getSpaceTotal() {
        return this.spaceTotal;
    }

    public long getSubspaceLocation() {
        return this.subspaceLocation;
    }

    public long getSubspaceTotal() {
        return this.subspaceTotal;
    }

    public long getLoaderFixupLocation() {
        return this.loaderFixupLocation;
    }

    public long getLoaderFixupTotal() {
        return this.loaderFixupTotal;
    }

    public long getSpaceStringsLocation() {
        return this.spaceStringsLocation;
    }

    public long getSpaceStringsSize() {
        return this.spaceStringsSize;
    }

    public long getInitArrayLocation() {
        return this.initArrayLocation;
    }

    public long getInitArrayTotal() {
        return this.initArrayTotal;
    }

    public long getCompilerLocation() {
        return this.compilerLocation;
    }

    public long getCompilerTotal() {
        return this.compilerTotal;
    }

    public long getSymbolLocation() {
        return this.symbolLocation;
    }

    public long getSymbolTotal() {
        return this.symbolTotal;
    }

    public long getFixupRequestLocation() {
        return this.fixupRequestLocation;
    }

    public long getFixupRequestTotal() {
        return this.fixupRequestTotal;
    }

    public long getSymbolStringsLocation() {
        return this.symbolStringsLocation;
    }

    public long getSymbolStringsSize() {
        return this.symbolStringsSize;
    }

    public long getUnloadableSpLocation() {
        return this.unloadableSpLocation;
    }

    public long getUnloadableSpSize() {
        return this.unloadableSpSize;
    }

    public long getChecksum() {
        return this.checksum;
    }

    public List<SomSpace> getSpaces() {
        return new ArrayList<SomSpace>(this.spaces);
    }

    public List<SomSubspace> getSubspaces() {
        return this.subspaces;
    }

    public List<SomAuxHeader> getAuxHeaders() {
        return this.auxHeaders;
    }

    public <T> List<T> getAuxHeaders(Class<T> classType) {
        ArrayList<T> tmp = new ArrayList<T>();
        for (SomAuxHeader auxHeader : this.auxHeaders) {
            if (!classType.isAssignableFrom(auxHeader.getClass())) continue;
            tmp.add(classType.cast(auxHeader));
        }
        return tmp;
    }

    public <T> T getFirstAuxHeader(Class<T> classType) {
        for (SomAuxHeader auxHeader : this.auxHeaders) {
            if (!classType.isAssignableFrom(auxHeader.getClass())) continue;
            return classType.cast(auxHeader);
        }
        return null;
    }

    public List<SomCompilationUnit> getCompilationUnits() {
        return this.compilationUnits;
    }

    public List<SomSymbol> getSymbols() {
        return this.symbols;
    }

    public Address getTextAddress(Program program) throws Exception {
        return program.getAddressFactory().getDefaultAddressSpace().getAddress(this.subspaces.get(this.spaces.get(0).getSubspaceIndex()).getSubspaceStart());
    }

    public Address getDataAddress(Program program) throws Exception {
        return program.getAddressFactory().getDefaultAddressSpace().getAddress(this.subspaces.get(this.spaces.get(1).getSubspaceIndex()).getSubspaceStart());
    }

    public void markup(Program program, Address headerAddr, TaskMonitor monitor) throws Exception {
        Address addr;
        Address addr2;
        DataUtilities.createData((Program)program, (Address)headerAddr, (DataType)this.toDataType(), (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
        monitor.initialize(this.spaceTotal, "Marking up spaces...");
        int i = 0;
        while ((long)i < this.spaceTotal) {
            monitor.increment();
            SomSpace space = this.spaces.get(i);
            addr2 = headerAddr.add(this.spaceLocation + (long)(i * 36));
            DataUtilities.createData((Program)program, (Address)addr2, (DataType)space.toDataType(), (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            program.getListing().setComment(addr2, CommentType.EOL, space.getName());
            ++i;
        }
        monitor.initialize(this.subspaceTotal, "Marking up subspaces...");
        i = 0;
        while ((long)i < this.subspaceTotal) {
            monitor.increment();
            SomSubspace subspace = this.subspaces.get(i);
            addr2 = headerAddr.add(this.subspaceLocation + (long)(i * 40));
            DataUtilities.createData((Program)program, (Address)addr2, (DataType)subspace.toDataType(), (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            program.getListing().setComment(addr2, CommentType.EOL, subspace.getName());
            ++i;
        }
        monitor.initialize((long)this.auxHeaders.size(), "Marking up auxiliary headers...");
        Address auxHeaderAddr = headerAddr.add(this.auxHeaderLocation);
        for (SomAuxHeader auxHeader : this.auxHeaders) {
            monitor.increment();
            DataUtilities.createData((Program)program, (Address)auxHeaderAddr, (DataType)auxHeader.toDataType(), (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            auxHeaderAddr = auxHeaderAddr.add(auxHeader.getLength());
        }
        monitor.initialize(this.compilerTotal, "Marking up compilation units...");
        int i2 = 0;
        while ((long)i2 < this.compilerTotal) {
            monitor.increment();
            SomCompilationUnit unit = this.compilationUnits.get(i2);
            addr = headerAddr.add(this.compilerLocation + (long)(i2 * 36));
            DataUtilities.createData((Program)program, (Address)addr, (DataType)unit.toDataType(), (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            program.getListing().setComment(addr, CommentType.EOL, unit.getName());
            ++i2;
        }
        monitor.initialize(this.symbolTotal, "Marking up symbols...");
        i2 = 0;
        while ((long)i2 < this.symbolTotal) {
            monitor.increment();
            SomSymbol symbol = this.symbols.get(i2);
            addr = headerAddr.add(this.symbolLocation + (long)(i2 * 20));
            DataUtilities.createData((Program)program, (Address)addr, (DataType)symbol.toDataType(), (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            program.getListing().setComment(addr, CommentType.EOL, symbol.getName());
            ++i2;
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("header", 128);
        struct.setPackingEnabled(true);
        struct.add(WORD, "system_id", "magic number - system");
        struct.add(WORD, "a_magic", "magic number - file type");
        struct.add(DWORD, "version_id", "version id; format=YYMMDDHH");
        struct.add(this.fileTime.toDataType(), "file_time", "system clock- zero if unused");
        struct.add(DWORD, "entry_space", "index of space containing entry point");
        struct.add(DWORD, "entry_subspace", "index of subspace for entry point");
        struct.add(DWORD, "entry_offset", "offset of entry point");
        struct.add(DWORD, "aux_header_location", "auxiliary header location");
        struct.add(DWORD, "aux_header_size", "auxiliary header size");
        struct.add(DWORD, "som_length", "length in bytes of entire som");
        struct.add(DWORD, "presumed_dp", "DP value assumed during compilation");
        struct.add(DWORD, "space_location", "location in file of space dictionary");
        struct.add(DWORD, "space_total", "number of space entries");
        struct.add(DWORD, "subspace_location", "location of subspace entries");
        struct.add(DWORD, "subspace_total", "number of subspace entries");
        struct.add(DWORD, "loader_fixup_location", "MPE/iX loader fixup");
        struct.add(DWORD, "loader_fixup_total", "number of loader fixup records");
        struct.add(DWORD, "space_strings_location", "file location of string area for space and subspace names");
        struct.add(DWORD, "space_strings_size", "size of string area for space and subspace names");
        struct.add(DWORD, "init_array_location", "reserved for use by system");
        struct.add(DWORD, "init_array_total", "reserved for use by system");
        struct.add(DWORD, "compiler_location", "location in file of module dictionary");
        struct.add(DWORD, "compiler_total", "number of modules");
        struct.add(DWORD, "symbol_location", "location in file of symbol dictionary");
        struct.add(DWORD, "symbol_total", "number of symbol records");
        struct.add(DWORD, "fixup_request_location", "location in file of fixup requests");
        struct.add(DWORD, "fixup_request_total", "number of fixup requests");
        struct.add(DWORD, "symbol_strings_location", "file location of string area for module and symbol names");
        struct.add(DWORD, "symbol_strings_size", "size of string area for module and symbol names");
        struct.add(DWORD, "unloadable_sp_location", "byte offset of first byte of data for unloadable spaces");
        struct.add(DWORD, "unloadable_sp_size", "byte length of data for unloadable spaces");
        struct.add(DWORD, "checksum", "");
        struct.setCategoryPath(new CategoryPath("/SOM"));
        return struct;
    }
}

