/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.pe.FileHeader;
import ghidra.app.util.bin.format.pe.InvalidNTHeaderException;
import ghidra.app.util.bin.format.pe.OffsetValidator;
import ghidra.app.util.bin.format.pe.OptionalHeader;
import ghidra.app.util.bin.format.pe.PortableExecutable;
import ghidra.app.util.bin.format.pe.SectionHeader;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.DataConverter;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class NTHeader
implements StructConverter,
OffsetValidator {
    public static final int SIZEOF_SIGNATURE = 4;
    public static final int MAX_SANE_COUNT = 65536;
    private int signature;
    private FileHeader fileHeader;
    private OptionalHeader optionalHeader;
    private BinaryReader reader;
    private int index;
    private boolean parseCliHeaders = false;
    private PortableExecutable.SectionLayout layout = PortableExecutable.SectionLayout.FILE;

    public NTHeader(BinaryReader reader, int index, PortableExecutable.SectionLayout layout, boolean parseCliHeaders) throws InvalidNTHeaderException, IOException {
        this.reader = reader;
        this.index = index;
        this.layout = layout;
        this.parseCliHeaders = parseCliHeaders;
        this.parse();
    }

    public String getName() {
        return "IMAGE_NT_HEADERS" + (this.optionalHeader.is64bit() ? "64" : "32");
    }

    public boolean isRVAResoltionSectionAligned() {
        return this.layout == PortableExecutable.SectionLayout.MEMORY;
    }

    public FileHeader getFileHeader() {
        return this.fileHeader;
    }

    public OptionalHeader getOptionalHeader() {
        return this.optionalHeader;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getName(), 0);
        struct.add((DataType)new ArrayDataType(ASCII, 4, 1), "Signature", null);
        struct.add(this.fileHeader.toDataType(), "FileHeader", null);
        struct.add(this.optionalHeader.toDataType(), "OptionalHeader", null);
        struct.setCategoryPath(new CategoryPath("/PE"));
        return struct;
    }

    public int rvaToPointer(int rva) {
        return (int)this.rvaToPointer(Integer.toUnsignedLong(rva));
    }

    public long rvaToPointer(long rva) {
        SectionHeader[] sections;
        for (SectionHeader section : sections = this.fileHeader.getSectionHeaders()) {
            long sectionVA = Integer.toUnsignedLong(section.getVirtualAddress());
            long vSize = Integer.toUnsignedLong(section.getVirtualSize());
            long rawPtr = Integer.toUnsignedLong(section.getPointerToRawData());
            long rawSize = Integer.toUnsignedLong(section.getSizeOfRawData());
            switch (this.layout) {
                case MEMORY: {
                    return rva;
                }
            }
            if (rva < sectionVA || rva >= sectionVA + vSize) continue;
            long ptr = rva + rawPtr - sectionVA;
            if (ptr >= rawPtr + rawSize) {
                return -1L;
            }
            return ptr;
        }
        if (this.optionalHeader != null && this.optionalHeader.getFileAlignment() == this.optionalHeader.getSectionAlignment() && this.optionalHeader.getSectionAlignment() < 800 && this.optionalHeader.getFileAlignment() > 1) {
            return rva;
        }
        return -1L;
    }

    @Override
    public boolean checkPointer(long ptr) {
        SectionHeader[] sections;
        for (SectionHeader section : sections = this.fileHeader.getSectionHeaders()) {
            long sectionSize;
            long virtPtr = Integer.toUnsignedLong(section.getVirtualAddress());
            long virtSize = Integer.toUnsignedLong(section.getVirtualSize());
            long rawSize = Integer.toUnsignedLong(section.getSizeOfRawData());
            long rawPtr = Integer.toUnsignedLong(section.getPointerToRawData());
            long sectionBasePtr = this.layout == PortableExecutable.SectionLayout.MEMORY ? virtPtr : rawPtr;
            long l = sectionSize = this.layout == PortableExecutable.SectionLayout.MEMORY ? virtSize : rawSize;
            if (ptr < sectionBasePtr || ptr > sectionBasePtr + sectionSize) continue;
            return true;
        }
        if (this.optionalHeader != null && this.optionalHeader.getFileAlignment() == this.optionalHeader.getSectionAlignment()) {
            return this.checkRVA(ptr);
        }
        return false;
    }

    @Override
    public boolean checkRVA(long rva) {
        if (this.optionalHeader != null) {
            return 0L <= rva && rva <= this.optionalHeader.getSizeOfImage();
        }
        return true;
    }

    public int vaToPointer(int va) {
        return (int)this.vaToPointer(Integer.toUnsignedLong(va));
    }

    public long vaToPointer(long va) {
        return this.rvaToPointer(va - this.getOptionalHeader().getImageBase());
    }

    private void parse() throws InvalidNTHeaderException, IOException {
        if (this.index < 0 || (long)this.index > this.reader.length()) {
            return;
        }
        int tmpIndex = this.index;
        try {
            this.signature = this.reader.readInt(tmpIndex);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        if (this.signature != 17744) {
            throw new InvalidNTHeaderException();
        }
        this.fileHeader = new FileHeader(this.reader, tmpIndex += 4, this);
        if (this.fileHeader.getSizeOfOptionalHeader() == 0) {
            Msg.warn((Object)this, (Object)"Section headers overlap optional header");
        }
        this.optionalHeader = new OptionalHeader(this, this.reader, tmpIndex += 20);
        boolean symbolsProcessed = false;
        try {
            this.fileHeader.processSymbols();
            symbolsProcessed = true;
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Failed to process symbols: " + e.getMessage()));
        }
        this.fileHeader.processSections(this.optionalHeader, symbolsProcessed);
    }

    void writeHeader(RandomAccessFile raf, DataConverter dc) throws IOException {
        SectionHeader[] sections;
        raf.seek(this.index);
        raf.write(dc.getBytes(this.signature));
        this.fileHeader.writeHeader(raf, dc);
        this.optionalHeader.writeHeader(raf, dc);
        for (SectionHeader section : sections = this.fileHeader.getSectionHeaders()) {
            section.writeHeader(raf, dc);
        }
    }

    boolean shouldParseCliHeaders() {
        return this.parseCliHeaders;
    }
}

