/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang;

import ghidra.framework.options.Options;
import ghidra.program.model.listing.Program;
import java.util.Objects;

public record GoVer(int major, int minor, int patch) implements Comparable<GoVer>
{
    public static final String GOLANG_VERSION_PROPERTY_NAME = "Golang go version";
    public static final GoVer INVALID = new GoVer(0, 0, 0);
    public static final GoVer ANY = new GoVer(-1, -1, -1);

    public static GoVer parse(String s) {
        return GoVer.parse(s, 0);
    }

    public static GoVer parseWildcardPatch(String s) {
        return GoVer.parse(s, -1);
    }

    private static GoVer parse(String s, int missingPatchValue) {
        String[] parts = Objects.requireNonNullElse(s, "").replaceAll("[^.0-9].*$", "").split("\\.");
        if (parts.length < 2) {
            return INVALID;
        }
        try {
            int major = Integer.parseInt(parts[0]);
            int minor = Integer.parseInt(parts[1]);
            int patch = parts.length > 2 ? Integer.parseInt(parts[2]) : missingPatchValue;
            return new GoVer(major, minor, patch);
        }
        catch (NumberFormatException numberFormatException) {
            return INVALID;
        }
    }

    public static GoVer fromProgramProperties(Program program) {
        Options props = program.getOptions("Program Information");
        String verStr = props.getString(GOLANG_VERSION_PROPERTY_NAME, null);
        return GoVer.parse(verStr, 0);
    }

    public static void setProgramPropertiesWithOriginalVersionString(Options props, String s) {
        props.setString(GOLANG_VERSION_PROPERTY_NAME, s);
    }

    public boolean isInvalid() {
        return this.major == 0 && this.minor == 0;
    }

    public boolean isWildcard() {
        return this.major == -1 && this.minor == -1;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public GoVer prevPatch() {
        return new GoVer(this.major, this.minor, this.patch > 0 ? this.patch - 1 : 0);
    }

    public GoVer withPatch(int newPatchNum) {
        return new GoVer(this.major, this.minor, newPatchNum);
    }

    @Override
    public int compareTo(GoVer o) {
        int result = Integer.compare(this.major, o.major);
        if (result == 0) {
            result = Integer.compare(this.minor, o.minor);
        }
        if (result == 0) {
            result = this.patch == -1 || o.patch == -1 ? 0 : Integer.compare(this.patch, o.patch);
        }
        return result;
    }

    @Override
    public String toString() {
        return this.patch != -1 ? "%d.%d.%d".formatted(this.major, this.minor, this.patch) : "%d.%d".formatted(this.major, this.minor);
    }
}

