/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.instructionsearch.ui;

import ghidra.app.plugin.core.instructionsearch.ui.ControlPanelWidget;
import ghidra.app.plugin.core.instructionsearch.ui.InsertBytesWidget;
import ghidra.app.plugin.core.instructionsearch.ui.SelectionModeWidget;
import ghidra.app.plugin.core.instructionsearch.util.InstructionSearchUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;

public class EndianFlipWidget
extends ControlPanelWidget {
    private InsertBytesWidget parent;

    public EndianFlipWidget(String title, InsertBytesWidget parent) {
        super(title);
        this.parent = parent;
    }

    @Override
    protected JPanel createContent() {
        JPanel mainPanel = new JPanel();
        JButton flipEndiannessBtn = new JButton("flip");
        mainPanel.add(flipEndiannessBtn);
        flipEndiannessBtn.addActionListener(new EndianFlipper());
        return mainPanel;
    }

    private List<String> getByteStrings(String token, int byteLength) {
        int n = token.length() / byteLength;
        ArrayList<String> list = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            list.add(token.substring(i * byteLength, i * byteLength + byteLength));
        }
        return list;
    }

    private class EndianFlipper
    implements ActionListener {
        private EndianFlipper() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String[] groups = EndianFlipWidget.this.parent.getInputString().trim().split("\\s+");
            List<String> whitespaces = InstructionSearchUtils.getWhitespace(EndianFlipWidget.this.parent.getInputString().trim());
            for (String str : groups) {
                if (EndianFlipWidget.this.parent.validateInput(str)) continue;
                EndianFlipWidget.this.parent.showError();
                return;
            }
            int byteLength = 0;
            if (EndianFlipWidget.this.parent.getSelectionModeWidget().getInputMode() == SelectionModeWidget.InputMode.HEX) {
                byteLength = 2;
            } else if (EndianFlipWidget.this.parent.getSelectionModeWidget().getInputMode() == SelectionModeWidget.InputMode.BINARY) {
                byteLength = 8;
            }
            if (groups.length != whitespaces.size() + 1) {
                return;
            }
            StringBuilder mainString = new StringBuilder();
            int whitespaceIndex = 0;
            for (String str : groups) {
                List<String> input = EndianFlipWidget.this.getByteStrings(str, byteLength);
                Collections.reverse(input);
                for (String s : input) {
                    mainString.append(s);
                }
                if (whitespaceIndex >= whitespaces.size()) continue;
                mainString.append(whitespaces.get(whitespaceIndex));
                ++whitespaceIndex;
            }
            EndianFlipWidget.this.parent.setInputString(mainString.toString());
        }
    }
}

