/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.module;

import ghidra.framework.cmd.Command;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.exception.DuplicateNameException;

public class CreateFragmentCmd
implements Command<Program> {
    private String name;
    private String statusMsg;
    private String parentName;
    private String treeName;

    public CreateFragmentCmd(String treeName, String name, String parentName) {
        this.treeName = treeName;
        this.name = name;
        this.parentName = parentName;
    }

    public boolean applyTo(Program program) {
        Listing listing = program.getListing();
        ProgramModule m = listing.getModule(this.treeName, this.parentName);
        if (m == null) {
            this.statusMsg = "Module named " + this.parentName + " does not exist";
            return false;
        }
        try {
            m.createFragment(this.name);
            return true;
        }
        catch (DuplicateNameException e) {
            this.statusMsg = this.name + " already exists";
            return false;
        }
    }

    public String getStatusMsg() {
        return this.statusMsg;
    }

    public String getName() {
        return "Create Fragment";
    }
}

