/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.jparted.app;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.layout.GroupLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainPanel
extends JPanel {
    private final PartitionTableModel partitionTableModel;
    private JScrollPane jScrollPane1;
    private JComboBox partitionSystemsBox;
    private JLabel partitionSystemsLabel;
    private JTable partitionTable;
    private JButton synchronizeButton;

    public MainPanel() {
        this.initComponents();
        this.partitionTableModel = new PartitionTableModel();
        this.partitionTableModel.setColumnIdentifiers(new String[]{"Number", "Type", "Name", "Start", "End"});
        this.partitionTable.setModel(this.partitionTableModel);
    }

    private void initComponents() {
        this.partitionSystemsLabel = new JLabel();
        this.partitionSystemsBox = new JComboBox();
        this.synchronizeButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.partitionTable = new JTable();
        this.partitionSystemsLabel.setText("Detected partition systems:");
        this.partitionSystemsBox.setModel(new DefaultComboBoxModel<String>(new String[]{"GUID Partition Table (6 partitions)", "Protective MBR (4 partitions)"}));
        this.synchronizeButton.setText("Synchronize");
        this.partitionTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}}, new String[]{"Number", "Type", "Name", "Start", "End"}));
        this.jScrollPane1.setViewportView(this.partitionTable);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.partitionSystemsLabel).addPreferredGap(0).add((Component)this.partitionSystemsBox, 0, 285, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.synchronizeButton).addContainerGap()).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 571, Short.MAX_VALUE).addContainerGap())));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.synchronizeButton).add((Component)this.partitionSystemsBox, -2, -1, -2).add((Component)this.partitionSystemsLabel)).addContainerGap(260, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(76, 76, 76).add((Component)this.jScrollPane1, -2, 211, -2).addContainerGap(-1, Short.MAX_VALUE))));
    }

    public void setPartitionSystemsBoxContents(Vector<String> contents) {
        this.partitionSystemsBox.removeAllItems();
        for (String currentItem : contents) {
            this.partitionSystemsBox.addItem(currentItem);
        }
    }

    public void setPartitionSystemsBoxEnabled(boolean enabled) {
        this.partitionSystemsBox.setEnabled(enabled);
    }

    public void setSynchronizeButtonEnabled(boolean enabled) {
        this.synchronizeButton.setEnabled(enabled);
    }

    public void setPartitionSystemsBoxListener(ActionListener listener) {
        for (ActionListener al : this.partitionSystemsBox.getActionListeners()) {
            this.partitionSystemsBox.removeActionListener(al);
        }
        this.partitionSystemsBox.addActionListener(listener);
    }

    public void setSynchronizeButtonListener(ActionListener listener) {
        for (ActionListener al : this.synchronizeButton.getActionListeners()) {
            this.synchronizeButton.removeActionListener(al);
        }
        this.synchronizeButton.addActionListener(listener);
    }

    public void clearPartitionList() {
        int rowCount = this.partitionTableModel.getRowCount();
        for (int i = rowCount - 1; i >= 0; --i) {
            this.partitionTableModel.removeRow(i);
        }
    }

    public void addPartition(String number, String type, String name, String start, String end) {
        this.partitionTableModel.addRow(new String[]{number, type, name, start, end});
    }

    private class PartitionTableModel
    extends DefaultTableModel {
        private PartitionTableModel() {
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    private class PartitionTableRow {
        public String number;
        public String type;
        public String name;
        public String start;
        public String end;

        public PartitionTableRow(String number, String type, String name, String start, String end) {
            this.number = number;
            this.type = type;
            this.name = name;
            this.start = start;
            this.end = end;
        }
    }
}

