/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.layout;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class Column<V> {
    public int x = -1;
    public int width = -1;
    public int index = Integer.MAX_VALUE;
    private TreeMap<Integer, V> verticesByRow = new TreeMap();
    private Map<V, Integer> rowsByVertex = new HashMap<V, Integer>();

    public Column(int index) {
        this.index = index;
    }

    public void setRow(V v, int row) {
        this.rowsByVertex.put((Integer)v, row);
        this.verticesByRow.put(row, v);
    }

    public int getRow(V v) {
        if (!this.rowsByVertex.containsKey(v)) {
            throw new IllegalArgumentException("Vertex is not in row: " + String.valueOf(v));
        }
        return this.rowsByVertex.get(v);
    }

    public int getPaddedWidth(boolean isCondensed) {
        if (isCondensed) {
            return this.width + 10;
        }
        return this.width + 50;
    }

    public boolean isInitialized() {
        return this.x > -1 && this.width > -1 && this.index > Integer.MAX_VALUE;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{\n\tcolumn: " + this.index + ",\n\tx: " + this.x + ",\n\twidth: " + this.width + ",\n\tpadded width: " + this.getPaddedWidth(false) + "\n}";
    }

    public boolean isOpenBetween(int startRow, int endRow) {
        Map.Entry<Integer, V> ceilingEntry = this.verticesByRow.ceilingEntry(startRow);
        if (ceilingEntry == null) {
            return true;
        }
        int nextRow = ceilingEntry.getKey();
        return nextRow > endRow;
    }
}

