/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.breakpoint;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.breakpoint.TraceBreakpointCommon;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.trace.model.breakpoint.TraceBreakpointSpec;
import ghidra.trace.model.target.info.TraceObjectInfo;
import ghidra.trace.model.thread.TraceThread;
import java.util.Set;

@TraceObjectInfo(schemaName="BreakpointLocation", shortName="breakpoint location", attributes={"_range", "_emu_enabled", "_emu_sleigh"}, fixedKeys={"_range"})
public interface TraceBreakpointLocation
extends TraceBreakpointCommon {
    public static final String KEY_RANGE = "_range";
    public static final String KEY_EMU_ENABLED = "_emu_enabled";
    public static final String KEY_EMU_SLEIGH = "_emu_sleigh";

    public TraceBreakpointSpec getSpecification();

    default public Set<TraceBreakpointKind> getKinds(long snap) {
        return this.getSpecification().getKinds(snap);
    }

    @Deprecated(forRemoval=true, since="12.0")
    public Set<TraceThread> getThreads(long var1);

    public void setRange(Lifespan var1, AddressRange var2);

    public AddressRange getRange(long var1);

    public Address getMinAddress(long var1);

    public Address getMaxAddress(long var1);

    public long getLength(long var1);

    public void setEmuEnabled(Lifespan var1, boolean var2);

    public void setEmuEnabled(long var1, boolean var3);

    public boolean isEmuEnabled(long var1);

    public void setEmuSleigh(Lifespan var1, String var2);

    public void setEmuSleigh(long var1, String var3);

    public String getEmuSleigh(long var1);
}

