/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.module;

import db.DBHandle;
import ghidra.framework.data.OpenMode;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceManager;
import ghidra.trace.database.target.DBTraceObjectManager;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.modules.TraceModuleManager;
import ghidra.trace.model.modules.TraceSection;
import ghidra.util.LockHold;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class DBTraceModuleManager
implements TraceModuleManager,
DBTraceManager {
    protected final ReadWriteLock lock;
    protected final DBTrace trace;
    protected final DBTraceObjectManager objectManager;

    public DBTraceModuleManager(DBHandle dbh, OpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, DBTrace trace, DBTraceObjectManager objectManager) throws VersionException, IOException {
        this.lock = lock;
        this.trace = trace;
        this.objectManager = objectManager;
    }

    public void dbError(IOException e) {
        this.trace.dbError(e);
    }

    @Override
    public void invalidateCache(boolean all) {
    }

    @Override
    public TraceModule addModule(String modulePath, String moduleName, AddressRange range, Lifespan lifespan) throws DuplicateNameException {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            TraceModule traceModule = this.doAddModule(modulePath, moduleName, range, lifespan);
            return traceModule;
        }
    }

    protected TraceModule doAddModule(String modulePath, String moduleName, AddressRange range, Lifespan lifespan) throws DuplicateNameException {
        return this.objectManager.addModule(modulePath, moduleName, lifespan, range);
    }

    protected Collection<? extends TraceModule> doGetModulesByPath(String modulePath) {
        return this.objectManager.getObjectsByPath(modulePath, TraceModule.class);
    }

    @Override
    public Collection<? extends TraceModule> getModulesByPath(String modulePath) {
        return Collections.unmodifiableCollection(this.doGetModulesByPath(modulePath));
    }

    @Override
    public TraceModule getLoadedModuleByPath(long snap, String modulePath) {
        return this.objectManager.getObjectByPath(snap, modulePath, TraceModule.class);
    }

    @Override
    public Collection<? extends TraceModule> getAllModules() {
        return this.objectManager.getAllObjects(TraceModule.class);
    }

    @Override
    public Collection<? extends TraceModule> getLoadedModules(long snap) {
        return this.objectManager.getObjectsAtSnap(snap, TraceModule.class);
    }

    @Override
    public Collection<? extends TraceModule> getModulesAt(long snap, Address address) {
        return this.objectManager.getObjectsContaining(snap, address, "_range", TraceModule.class);
    }

    @Override
    public Collection<? extends TraceModule> getModulesIntersecting(Lifespan lifespan, AddressRange range) {
        return this.objectManager.getObjectsIntersecting(lifespan, range, "_range", TraceModule.class);
    }

    @Override
    public Collection<? extends TraceSection> getSectionsAt(long snap, Address address) {
        return this.objectManager.getObjectsContaining(snap, address, "_range", TraceSection.class);
    }

    @Override
    public Collection<? extends TraceSection> getSectionsIntersecting(Lifespan lifespan, AddressRange range) {
        return this.objectManager.getObjectsIntersecting(lifespan, range, "_range", TraceSection.class);
    }

    @Override
    public Collection<? extends TraceSection> getAllSections() {
        return this.objectManager.getAllObjects(TraceSection.class);
    }

    protected Collection<? extends TraceSection> doGetSectionsByPath(String sectionPath) {
        return this.objectManager.getObjectsByPath(sectionPath, TraceSection.class);
    }

    @Override
    public Collection<? extends TraceSection> getSectionsByPath(String sectionPath) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            Collection<? extends TraceSection> collection = Collections.unmodifiableCollection(this.doGetSectionsByPath(sectionPath));
            return collection;
        }
    }

    @Override
    public TraceSection getLoadedSectionByPath(long snap, String sectionPath) {
        return this.objectManager.getObjectByPath(snap, sectionPath, TraceSection.class);
    }
}

