/*
 * Decompiled with CFR 0.152.
 */
package docking.menu.keys;

import docking.menu.keys.EndMenuKeyHandler;
import docking.menu.keys.HomeMenuKeyHandler;
import docking.menu.keys.MenuKeyHandler;
import docking.menu.keys.NumberMenuKeyHandler;
import docking.menu.keys.PageDownMenuKeyHandler;
import docking.menu.keys.PageUpMenuKeyHandler;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;

public class MenuKeyProcessor {
    private static Map<KeyStroke, MenuKeyHandler> menuHandlersByKeyStroke = new HashMap<KeyStroke, MenuKeyHandler>();

    public static boolean processMenuKeyEvent(KeyEvent event) {
        MenuSelectionManager manager = MenuSelectionManager.defaultManager();
        MenuElement[] path = manager.getSelectedPath();
        if (!MenuKeyProcessor.hasJPopupMenu(path)) {
            return false;
        }
        KeyStroke eventStroke = KeyStroke.getKeyStrokeForEvent(event);
        MenuKeyHandler Handler2 = menuHandlersByKeyStroke.get(eventStroke);
        if (Handler2 != null) {
            Handler2.process(manager, path);
            event.consume();
            return true;
        }
        return false;
    }

    private static boolean hasJPopupMenu(MenuElement[] path) {
        if (path == null || path.length == 0) {
            return false;
        }
        for (MenuElement element : path) {
            if (!element.getClass().equals(JPopupMenu.class)) continue;
            return true;
        }
        return false;
    }

    private static KeyStroke keyStroke(String s) {
        return KeyStroke.getKeyStroke("pressed " + s);
    }

    static {
        menuHandlersByKeyStroke.put(MenuKeyProcessor.keyStroke("HOME"), new HomeMenuKeyHandler());
        menuHandlersByKeyStroke.put(MenuKeyProcessor.keyStroke("END"), new EndMenuKeyHandler());
        menuHandlersByKeyStroke.put(MenuKeyProcessor.keyStroke("PAGE_UP"), new PageUpMenuKeyHandler());
        menuHandlersByKeyStroke.put(MenuKeyProcessor.keyStroke("PAGE_DOWN"), new PageDownMenuKeyHandler());
        for (int i = 1; i < 10; ++i) {
            menuHandlersByKeyStroke.put(MenuKeyProcessor.keyStroke(Integer.toString(i)), new NumberMenuKeyHandler(i));
        }
    }
}

