/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.filters;

import ghidra.features.bsim.gui.filters.BSimFilterType;
import ghidra.features.bsim.gui.filters.BSimValueEditor;
import ghidra.features.bsim.gui.filters.MultiChoiceBSimValueEditor;
import ghidra.features.bsim.query.client.IDSQLResolution;
import ghidra.features.bsim.query.client.SQLEffects;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.elastic.ElasticEffects;
import ghidra.features.bsim.query.elastic.ElasticException;
import ghidra.features.bsim.query.elastic.IDElasticResolution;
import ghidra.features.bsim.query.protocol.FilterAtom;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.util.DefaultLanguageService;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import utility.function.Callback;

public class ArchitectureBSimFilterType
extends BSimFilterType {
    public static final String XML_VALUE = "archequals";

    public ArchitectureBSimFilterType() {
        super("Architecture equals", XML_VALUE, "x86:LE:64:default");
    }

    @Override
    public void gatherSQLEffect(SQLEffects effect, FilterAtom atom, IDSQLResolution resolution) throws SQLException {
        effect.setExeTable();
        StringBuilder buf = new StringBuilder();
        buf.append("exetable.architecture=").append(resolution.id1);
        effect.addWhere(this, buf.toString());
    }

    @Override
    public void gatherElasticEffect(ElasticEffects effect, FilterAtom atom, IDElasticResolution resolution) throws ElasticException {
        effect.addDocValue("String arch = doc['architecture'].value; ");
        String argName = effect.assignArgument();
        effect.addScriptElement(this, "arch == params." + argName);
        effect.addParam(argName, atom.value);
    }

    @Override
    public boolean evaluate(ExecutableRecord rec, String value) {
        return value.equals(rec.getArchitecture());
    }

    @Override
    public IDSQLResolution generateIDSQLResolution(FilterAtom atom) {
        return new IDSQLResolution.Architecture(atom.value);
    }

    @Override
    public BSimValueEditor getEditor(List<String> initialValues, Callback listener) {
        List<String> choices = ArchitectureBSimFilterType.getArchitectures();
        return new MultiChoiceBSimValueEditor(this, choices, initialValues, "Architecture", listener);
    }

    public static List<String> getArchitectures() {
        LanguageService service = DefaultLanguageService.getLanguageService();
        List languages = service.getLanguageDescriptions(true);
        return languages.stream().map(l -> l.getLanguageID().toString()).collect(Collectors.toList());
    }
}

