/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.go;

import ghidra.app.plugin.core.go.exception.StartedGhidraProcessExitedException;
import ghidra.app.plugin.core.go.exception.StopWaitingException;
import ghidra.app.plugin.core.go.exception.UnableToGetLockException;
import ghidra.app.plugin.core.go.ipc.CheckForFileProcessedRunnable;
import ghidra.app.plugin.core.go.ipc.CheckForListenerRunnable;
import ghidra.app.plugin.core.go.ipc.GhidraGoIPC;
import ghidra.util.Msg;
import ghidra.util.Swing;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;

public class GhidraGoSender
extends GhidraGoIPC {
    @Override
    public void dispose() {
    }

    public boolean doLockedAction(boolean waitForLock, Supplier<Boolean> action) throws UnableToGetLockException {
        return GhidraGoIPC.doLockedAction(this.senderLockPath, waitForLock, action);
    }

    public void send(String url) throws StopWaitingException {
        if (StringUtils.isEmpty((CharSequence)url)) {
            Swing.runNow(() -> Msg.showError((Object)this, null, (String)"GhidraGo Empty URL Error", (Object)"An empty GhidraURL cannot be sent."));
            return;
        }
        String fileName = UUID.randomUUID().toString();
        Path randomFilePath = this.channelPath.resolve(fileName);
        Path writtenFilePath = this.urlFilesPath.resolve(fileName);
        try (FileOutputStream fos = new FileOutputStream(randomFilePath.toFile());){
            fos.write(url.getBytes());
            fos.close();
            Files.move(randomFilePath, writtenFilePath, new CopyOption[0]);
        }
        catch (IOException e) {
            randomFilePath.toFile().delete();
            Swing.runNow(() -> Msg.showError((Object)this, null, (String)"GhidraGo Error Sending URL", (Object)"There was a file system error preventing the url from being sent.", (Throwable)e));
        }
        Msg.info((Object)this, (Object)("Wrote " + url + " to random file " + String.valueOf(writtenFilePath)));
        if (writtenFilePath.toFile().exists()) {
            this.waitForFileToBeProcessed(writtenFilePath);
        }
    }

    private void waitForFileToBeProcessed(Path filePath) throws StopWaitingException {
        if (filePath.toFile().exists()) {
            CheckForFileProcessedRunnable checkForFile = new CheckForFileProcessedRunnable(filePath, 100, TimeUnit.MILLISECONDS);
            checkForFile.startChecking(100, TimeUnit.MILLISECONDS);
            checkForFile.awaitTermination();
        }
    }

    public void waitForListener() throws StopWaitingException {
        try {
            this.waitForListener(null);
        }
        catch (StartedGhidraProcessExitedException startedGhidraProcessExitedException) {
            // empty catch block
        }
    }

    public void waitForListener(Process p) throws StopWaitingException, StartedGhidraProcessExitedException {
        if (!this.isGhidraListening()) {
            CheckForListenerRunnable checkForListener = new CheckForListenerRunnable(p, 100, TimeUnit.MILLISECONDS, () -> !this.isGhidraListening());
            checkForListener.startChecking(100, TimeUnit.MILLISECONDS);
            checkForListener.awaitTermination();
        }
    }
}

