/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.client.tracermi;

import ghidra.app.plugin.core.debug.client.tracermi.RmiClient;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;

public class RmiBatch
implements AutoCloseable {
    private final RmiClient client;
    private volatile int refCount = 0;
    private final List<RmiClient.RequestResult> futures = new ArrayList<RmiClient.RequestResult>();

    public RmiBatch(RmiClient client) {
        this.client = client;
    }

    public void inc() {
        ++this.refCount;
    }

    public int dec() {
        return --this.refCount;
    }

    @Override
    public void close() {
        try {
            this.client.endBatch(this);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(RmiClient.RequestResult f) {
        List<RmiClient.RequestResult> list = this.futures;
        synchronized (list) {
            this.futures.add(f);
        }
    }

    public List<Object> results() throws InterruptedException, ExecutionException {
        List<RmiClient.RequestResult> futures = this.futures();
        ArrayList<Object> results = new ArrayList<Object>(futures.size());
        for (RmiClient.RequestResult r : futures) {
            results.add(r.get());
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RmiClient.RequestResult> futures() {
        List<RmiClient.RequestResult> list = this.futures;
        synchronized (list) {
            return List.copyOf(this.futures);
        }
    }
}

