/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.debug;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.debug.DebugSymbol;
import java.io.IOException;

class S_LDATA32_NEW
extends DebugSymbol {
    private int reserved;
    private byte[] padding;

    S_LDATA32_NEW(short length, short type, BinaryReader reader, int ptr) throws IOException {
        this.processDebugSymbol(length, type);
        this.reserved = reader.readInt(ptr);
        this.offset = reader.readInt(ptr += 4);
        this.section = reader.readShort(ptr += 4);
        byte nameLen = reader.readByte(ptr += 2);
        this.name = reader.readAsciiString(++ptr, Byte.toUnsignedInt(nameLen));
        int sizeOfPadding = Short.toUnsignedInt(length) - 2 - 4 - 4 - 2 - 1 - Byte.toUnsignedInt(nameLen);
        this.padding = reader.readByteArray(ptr += Byte.toUnsignedInt(nameLen), sizeOfPadding);
    }

    public int getReserved() {
        return this.reserved;
    }

    public byte[] getPadding() {
        return this.padding;
    }
}

