/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.renderer;

import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import generic.theme.GThemeDefaults;
import ghidra.util.Swing;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.concurrent.atomic.AtomicInteger;

public class DebugShape<V, E>
implements VisualizationServer.Paintable {
    private Shape shape;
    private Color color;
    private String text;
    private VisualizationServer<V, E> viewer;
    private AtomicInteger drawingIterationCounter;
    private final int drawingIterationID;

    public DebugShape(VisualizationServer<V, E> viewer, AtomicInteger drawingIterationCounter, String text, Shape shape, Color color) {
        this.viewer = viewer;
        this.drawingIterationCounter = drawingIterationCounter;
        this.text = text == null ? "no text" : text;
        this.shape = shape;
        this.color = color;
        this.drawingIterationID = drawingIterationCounter.get();
    }

    public Shape getShape() {
        return this.shape;
    }

    public Color getColor() {
        return this.color;
    }

    public void paint(Graphics g) {
        if (g instanceof Graphics2D) {
            this.doPaint((Graphics2D)g);
        }
    }

    public void paint(GraphicsDecorator g) {
        Graphics2D delegate = g.getDelegate();
        this.doPaint(delegate);
    }

    private void doPaint(Graphics2D g) {
        if (this.shapeIsOutdated()) {
            return;
        }
        Color originalColor = g.getColor();
        g.setColor(this.getColor());
        g.draw(this.shape);
        g.setColor((Color)GThemeDefaults.Colors.Palette.BLACK);
        FontMetrics fontMetrics = g.getFontMetrics();
        Rectangle2D stringBounds = fontMetrics.getStringBounds(this.text, g);
        Point location = this.shape.getBounds().getLocation();
        location.y += this.shape.getBounds().height + stringBounds.getBounds().height;
        g.drawString(this.text, location.x, location.y);
        g.setColor(originalColor);
    }

    private boolean shapeIsOutdated() {
        if (this.drawingIterationID != this.drawingIterationCounter.get()) {
            Swing.runLater(() -> this.viewer.removePostRenderPaintable((VisualizationServer.Paintable)this));
            return true;
        }
        return false;
    }

    public boolean useTransform() {
        return true;
    }
}

