/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.event.picking;

import edu.uci.ics.jung.visualization.picking.MultiPickedState;
import edu.uci.ics.jung.visualization.picking.PickedState;
import ghidra.graph.viewer.event.picking.PickListener;
import java.awt.event.ItemListener;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class GPickedState<V>
implements PickedState<V> {
    private Set<PickListener<V>> listeners = new CopyOnWriteArraySet<PickListener<V>>();
    private final MultiPickedState<V> pickedStateDelegate;
    private PickListener.EventSource pendingEventSource = null;

    public GPickedState(MultiPickedState<V> pickedState) {
        this.pickedStateDelegate = pickedState;
        pickedState.addItemListener(e -> {
            PickListener.EventSource source = this.pendingEventSource != null ? this.pendingEventSource : PickListener.EventSource.INTERNAL;
            MultiPickedState state = (MultiPickedState)e.getSource();
            Object[] selectedObjects = state.getSelectedObjects();
            this.notifyVerticesPicked(selectedObjects, source);
        });
    }

    private void notifyVerticesPicked(Object[] selectedVertices, PickListener.EventSource source) {
        Set<V> vertices = this.getSet(selectedVertices);
        for (PickListener<V> listener : this.listeners) {
            listener.verticesPicked(vertices, source);
        }
    }

    private Set<V> getSet(Object[] vertices) {
        HashSet<Object> set = new HashSet<Object>();
        for (Object vertice : vertices) {
            set.add(vertice);
        }
        return set;
    }

    public void addPickingListener(PickListener<V> pickListener) {
        this.listeners.add(pickListener);
    }

    public void removePickingListener(PickListener<V> pickListener) {
        this.listeners.remove(pickListener);
    }

    public void pickToSync(V vertex) {
        this.pickToSync(vertex, false);
    }

    public void pickToSync(V vertex, boolean addToSelection) {
        this.pendingEventSource = PickListener.EventSource.EXTERNAL;
        if (!addToSelection) {
            this.pickedStateDelegate.clear();
        }
        this.pickedStateDelegate.pick(vertex, true);
        this.pendingEventSource = null;
    }

    public void pickToActivate(V vertex) {
        this.pendingEventSource = PickListener.EventSource.INTERNAL;
        this.pickedStateDelegate.clear();
        this.pickedStateDelegate.pick(vertex, true);
        this.pendingEventSource = null;
    }

    public boolean pick(V vertex, boolean b) {
        this.pendingEventSource = PickListener.EventSource.INTERNAL;
        boolean result = this.pickedStateDelegate.pick(vertex, b);
        this.pendingEventSource = null;
        return result;
    }

    public void clear() {
        this.pendingEventSource = PickListener.EventSource.INTERNAL;
        this.pickedStateDelegate.clear();
        this.pendingEventSource = null;
    }

    public Set<V> getPicked() {
        return this.pickedStateDelegate.getPicked();
    }

    public boolean isPicked(V vertex) {
        return this.pickedStateDelegate.isPicked(vertex);
    }

    public Object[] getSelectedObjects() {
        return this.pickedStateDelegate.getSelectedObjects();
    }

    public void addItemListener(ItemListener l) {
        this.pickedStateDelegate.addItemListener(l);
    }

    public void removeItemListener(ItemListener l) {
        this.pickedStateDelegate.removeItemListener(l);
    }
}

