/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.searchlist;

import docking.widgets.searchlist.SearchListEntry;
import docking.widgets.searchlist.SearchListModel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import javax.swing.AbstractListModel;
import utility.function.Dummy;

public class DefaultSearchListModel<T>
extends AbstractListModel<SearchListEntry<T>>
implements SearchListModel<T> {
    private Map<String, List<T>> dataMap = new LinkedHashMap<String, List<T>>();
    private List<SearchListEntry<T>> displayEntries;
    private BiPredicate<T, String> currentFilter = Dummy.biPredicate();

    @Override
    public int getSize() {
        this.buildEntriesIfNeeded();
        return this.displayEntries.size();
    }

    @Override
    public SearchListEntry<T> getElementAt(int index) {
        this.buildEntriesIfNeeded();
        return this.displayEntries.get(index);
    }

    public void add(String category, List<T> items) {
        List list = this.dataMap.computeIfAbsent(category, c -> new ArrayList());
        list.addAll(items);
        this.displayEntries = null;
    }

    public void fireDataChanged() {
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public void clearData() {
        this.dataMap.clear();
        this.displayEntries = null;
    }

    @Override
    public void setFilter(BiPredicate<T, String> filter) {
        this.currentFilter = filter;
        this.displayEntries = null;
        this.rebuildDisplayItems();
        this.fireDataChanged();
    }

    private void buildEntriesIfNeeded() {
        if (this.displayEntries == null) {
            this.rebuildDisplayItems();
        }
    }

    @Override
    public List<String> getCategories() {
        return new ArrayList<String>(this.dataMap.keySet());
    }

    @Override
    public void dispose() {
        this.dataMap = null;
        this.displayEntries = null;
    }

    public List<SearchListEntry<T>> getDisplayedItems() {
        this.buildEntriesIfNeeded();
        return new ArrayList<SearchListEntry<T>>(this.displayEntries);
    }

    public List<SearchListEntry<T>> getAllItems() {
        return this.getFilteredEntries(Dummy.biPredicate());
    }

    private void rebuildDisplayItems() {
        this.displayEntries = this.getFilteredEntries(this.currentFilter);
    }

    private List<SearchListEntry<T>> getFilteredEntries(BiPredicate<T, String> filter) {
        ArrayList<SearchListEntry<T>> entries = new ArrayList<SearchListEntry<T>>();
        Iterator<String> it = this.dataMap.keySet().iterator();
        while (it.hasNext()) {
            String category = it.next();
            List<T> list = this.getFilteredItems(category, filter);
            for (T value : list) {
                boolean isFirst = list.get(0) == value;
                boolean isLastInCateogry = list.get(list.size() - 1) == value;
                boolean isLastCategory = !it.hasNext();
                boolean showSeparator = isLastInCateogry && !isLastCategory;
                entries.add(new SearchListEntry<T>(value, category, isFirst, showSeparator));
            }
        }
        return entries;
    }

    private List<T> getFilteredItems(String category, BiPredicate<T, String> filter) {
        ArrayList<T> filtered = new ArrayList<T>();
        List<T> list = this.dataMap.get(category);
        for (T value : list) {
            if (!filter.test(value, category)) continue;
            filtered.add(value);
        }
        return filtered;
    }
}

