/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.util;

import ghidra.feature.vt.api.impl.MatchSetImpl;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTAssociationManager;
import ghidra.feature.vt.api.main.VTAssociationType;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTMatchInfo;
import ghidra.feature.vt.api.main.VTMatchSet;
import ghidra.feature.vt.api.main.VTScore;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.plugin.AddressCorrelatorManager;
import ghidra.feature.vt.gui.provider.impliedmatches.VTImpliedMatchInfo;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.util.AddressCorrelation;
import ghidra.program.util.AddressCorrelationRange;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ImpliedMatchUtils {
    public static void updateImpliedMatchForAcceptedAssocation(Function sourceFunction, Function destinationFunction, VTSession session, AddressCorrelatorManager correlatorManager, TaskMonitor monitor) throws CancelledException {
        Set<VTImpliedMatchInfo> impliedMatches = ImpliedMatchUtils.findImpliedMatches(sourceFunction, destinationFunction, session, correlatorManager, monitor);
        for (VTImpliedMatchInfo impliedMatch : impliedMatches) {
            Address sourceAddress = impliedMatch.getSourceAddress();
            Address destinationAddress = impliedMatch.getDestinationAddress();
            VTAssociation existingAssociation = session.getAssociationManager().getAssociation(sourceAddress, destinationAddress);
            if (existingAssociation == null) {
                VTMatchSet impliedMatchSet = session.getImpliedMatchSet();
                VTMatch match = impliedMatchSet.addMatch(impliedMatch);
                existingAssociation = match.getAssociation();
            }
            if (existingAssociation == null) continue;
            existingAssociation.setVoteCount(existingAssociation.getVoteCount() + 1);
        }
    }

    public static void updateImpliedMatchForClearedAssocation(Function sourceFunction, Function destinationFunction, VTSession session, AddressCorrelatorManager correlatorManager, TaskMonitor monitor) throws CancelledException {
        Set<VTImpliedMatchInfo> impliedMatches = ImpliedMatchUtils.findImpliedMatches(sourceFunction, destinationFunction, session, correlatorManager, monitor);
        for (VTImpliedMatchInfo impliedMatch : impliedMatches) {
            Address sourceAddress = impliedMatch.getSourceAddress();
            Address destinationAddress = impliedMatch.getDestinationAddress();
            VTAssociation existingAssociation = session.getAssociationManager().getAssociation(sourceAddress, destinationAddress);
            if (existingAssociation == null) continue;
            int newVoteCount = Math.max(0, existingAssociation.getVoteCount() - 1);
            existingAssociation.setVoteCount(newVoteCount);
            if (newVoteCount != 0) continue;
            ImpliedMatchUtils.removeImpliedMatch(existingAssociation);
        }
    }

    private static void removeImpliedMatch(VTAssociation existingAssociation) {
        VTSession session = existingAssociation.getSession();
        List<VTMatch> matches = session.getMatches(existingAssociation);
        VTMatchSet impliedMatchSet = session.getImpliedMatchSet();
        for (VTMatch vtMatch : matches) {
            if (vtMatch.getMatchSet() != impliedMatchSet) continue;
            impliedMatchSet.deleteMatch(vtMatch);
        }
    }

    public static Set<VTImpliedMatchInfo> findImpliedMatches(Function sourceFunction, Function destinationFunction, VTSession session, AddressCorrelatorManager correlatorManager, TaskMonitor monitor) throws CancelledException {
        HashSet<VTImpliedMatchInfo> set = new HashSet<VTImpliedMatchInfo>();
        AddressCorrelation correlator = correlatorManager.getCorrelator(sourceFunction, destinationFunction);
        MatchSetImpl possibleMatchSet = new MatchSetImpl(session, "Possible Implied Match");
        ReferenceManager referenceManager = sourceFunction.getProgram().getReferenceManager();
        AddressSetView body = sourceFunction.getBody();
        AddressIterator iterator = referenceManager.getReferenceSourceIterator(body, true);
        while (iterator.hasNext()) {
            Reference[] referencesFrom;
            monitor.checkCancelled();
            Address address = iterator.next();
            for (Reference reference : referencesFrom = referenceManager.getReferencesFrom(address)) {
                monitor.checkCancelled();
                VTImpliedMatchInfo match = ImpliedMatchUtils.findImpliedMatch(correlator, sourceFunction, destinationFunction, reference, possibleMatchSet, monitor);
                if (match == null) continue;
                set.add(match);
            }
        }
        return set;
    }

    private static VTImpliedMatchInfo findImpliedMatch(AddressCorrelation correlator, Function sourceFunction, Function destinationFunction, Reference sourceRef, VTMatchSet possibleMatchSet, TaskMonitor monitor) throws CancelledException {
        VTAssociationType type;
        RefType refType = sourceRef.getReferenceType();
        if (!refType.isCall() && !refType.isData()) {
            return null;
        }
        Address srcRefToAddress = sourceRef.getToAddress();
        if (!srcRefToAddress.isMemoryAddress()) {
            return null;
        }
        srcRefToAddress = ImpliedMatchUtils.getReference(sourceFunction.getProgram(), srcRefToAddress);
        Address srcRefFromAddress = sourceRef.getFromAddress();
        AddressCorrelationRange range = correlator.getCorrelatedDestinationRange(srcRefFromAddress, monitor);
        if (range == null) {
            return null;
        }
        Address destinationAddress = range.getMinAddress();
        ReferenceManager destRefMgr = destinationFunction.getProgram().getReferenceManager();
        Reference[] referencesFrom = destRefMgr.getReferencesFrom(destinationAddress);
        Reference destinationRef = ImpliedMatchUtils.findMatchingRef(refType, referencesFrom);
        if (destinationRef == null) {
            return null;
        }
        Address destRefToAddress = destinationRef.getToAddress();
        destRefToAddress = ImpliedMatchUtils.getReference(destinationFunction.getProgram(), destRefToAddress);
        VTImpliedMatchInfo matchInfo = new VTImpliedMatchInfo(possibleMatchSet, sourceRef, destinationRef);
        matchInfo.setSourceAddress(srcRefToAddress);
        matchInfo.setDestinationAddress(destRefToAddress);
        if (refType.isData()) {
            type = VTAssociationType.DATA;
            if (sourceFunction.getProgram().getListing().getInstructionAt(srcRefToAddress) != null) {
                if (refType != RefType.DATA) {
                    return null;
                }
                type = VTAssociationType.FUNCTION;
            }
        } else {
            type = VTAssociationType.FUNCTION;
        }
        if (type == VTAssociationType.FUNCTION) {
            if (sourceFunction.getProgram().getFunctionManager().getFunctionAt(srcRefToAddress) == null) {
                return null;
            }
            if (destinationFunction.getProgram().getFunctionManager().getFunctionAt(destRefToAddress) == null) {
                return null;
            }
        }
        matchInfo.setAssociationType(type);
        matchInfo.setSimilarityScore(new VTScore(0.0));
        matchInfo.setConfidenceScore(new VTScore(1.0));
        ImpliedMatchUtils.updateVTSourceAndDestinationLengths(matchInfo);
        return matchInfo;
    }

    private static Address getReference(Program program, Address refToAddress) {
        Function referencedFunction = program.getFunctionManager().getFunctionAt(refToAddress);
        if (referencedFunction != null && referencedFunction.isThunk()) {
            refToAddress = referencedFunction.getThunkedFunction(true).getEntryPoint();
        }
        return refToAddress;
    }

    private static void updateVTSourceAndDestinationLengths(VTMatchInfo matchInfo) {
        VTSession session = matchInfo.getMatchSet().getSession();
        Program sourceProgram = session.getSourceProgram();
        Program destinationProgram = session.getDestinationProgram();
        Address sourceAddress = matchInfo.getSourceAddress();
        Address destinationAddress = matchInfo.getDestinationAddress();
        if (matchInfo.getAssociationType() == VTAssociationType.FUNCTION) {
            Function sourceFunction = sourceProgram.getFunctionManager().getFunctionAt(sourceAddress);
            Function destFunction = destinationProgram.getFunctionManager().getFunctionAt(destinationAddress);
            if (sourceFunction != null) {
                matchInfo.setSourceLength((int)sourceFunction.getBody().getNumAddresses());
            }
            if (destFunction != null) {
                matchInfo.setDestinationLength((int)destFunction.getBody().getNumAddresses());
            }
        } else {
            CodeUnit cu = sourceProgram.getListing().getCodeUnitContaining(sourceAddress);
            if (cu != null) {
                matchInfo.setSourceLength(cu.getLength());
            }
            if ((cu = destinationProgram.getListing().getCodeUnitContaining(destinationAddress)) != null) {
                matchInfo.setDestinationLength(cu.getLength());
            }
        }
    }

    private static Reference findMatchingRef(RefType refType, Reference[] referencesFrom) {
        if (referencesFrom == null) {
            return null;
        }
        for (Reference reference : referencesFrom) {
            if (reference.getReferenceType() != refType) continue;
            return reference;
        }
        return null;
    }

    public static VTMatch resolveImpliedMatch(VTImpliedMatchInfo impliedMatch, VTSession session) {
        Address destinationAddress;
        Address sourceAddress;
        VTAssociationManager associationManager = session.getAssociationManager();
        VTAssociation existingAssociation = associationManager.getAssociation(sourceAddress = impliedMatch.getSourceAddress(), destinationAddress = impliedMatch.getDestinationAddress());
        if (existingAssociation != null) {
            VTMatch bestMatch = ImpliedMatchUtils.getBestMatch(existingAssociation, session);
            return bestMatch;
        }
        return null;
    }

    private static VTMatch getBestMatch(VTAssociation association, VTSession session) {
        List<VTMatch> matches = session.getMatches(association);
        int n = matches.size();
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return matches.get(0);
        }
        VTMatch bestMatch = matches.get(0);
        VTScore bestScore = bestMatch.getSimilarityScore();
        for (VTMatch vtMatch : matches) {
            if (vtMatch.getSimilarityScore().compareTo(bestScore) <= 0) continue;
            bestMatch = vtMatch;
            bestScore = bestMatch.getSimilarityScore();
        }
        return bestMatch;
    }

    public static Function getSourceFunction(VTSession session, VTAssociation association) {
        Program sourceProgram = session.getSourceProgram();
        Address sourceAddress = association.getSourceAddress();
        FunctionManager functionManager = sourceProgram.getFunctionManager();
        return functionManager.getFunctionAt(sourceAddress);
    }

    public static Function getDestinationFunction(VTSession session, VTAssociation association) {
        Program destinationProgram = session.getDestinationProgram();
        Address destinationAddress = association.getDestinationAddress();
        FunctionManager functionManager = destinationProgram.getFunctionManager();
        return functionManager.getFunctionAt(destinationAddress);
    }
}

