/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.DBHandle;
import db.DBLongIterator;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.Table;
import ghidra.program.database.map.AddressIndexKeyIterator;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.symbol.EquateRefDBAdapter;
import ghidra.program.database.util.DatabaseTableUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

class EquateRefDBAdapterV1
extends EquateRefDBAdapter {
    private Table refTable;
    private AddressMap addrMap;

    EquateRefDBAdapterV1(DBHandle handle, AddressMap addrMap, boolean create) throws IOException, VersionException {
        this.addrMap = addrMap;
        if (create) {
            this.refTable = handle.createTable("Equate References", REFS_SCHEMA, new int[]{0, 1});
        } else {
            this.refTable = handle.getTable("Equate References");
            if (this.refTable == null) {
                throw new VersionException("Missing Table: Equate References");
            }
            int version = this.refTable.getSchema().getVersion();
            if (version != 1) {
                if (version < 1) {
                    throw new VersionException(true);
                }
                throw new VersionException(2, false);
            }
        }
    }

    @Override
    DBRecord getRecord(long key) throws IOException {
        return this.refTable.getRecord(key);
    }

    @Override
    DBRecord createReference(long addr, short opIndex, long dynamicHash, long equateID) throws IOException {
        DBRecord rec = this.refTable.getSchema().createRecord(this.refTable.getKey());
        rec.setLongValue(1, addr);
        rec.setShortValue(2, opIndex);
        rec.setLongValue(3, dynamicHash);
        rec.setLongValue(0, equateID);
        this.refTable.putRecord(rec);
        return rec;
    }

    @Override
    Field[] getRecordKeysForAddr(long addr) throws IOException {
        return this.refTable.findRecords((Field)new LongField(addr), 1);
    }

    @Override
    void updateRecord(DBRecord record) throws IOException {
        this.refTable.putRecord(record);
    }

    @Override
    Field[] getRecordKeysForEquateID(long equateID) throws IOException {
        return this.refTable.findRecords((Field)new LongField(equateID), 0);
    }

    @Override
    DBLongIterator getIteratorForAddresses() throws IOException {
        return new AddressIndexKeyIterator(this.refTable, 1, this.addrMap, true);
    }

    @Override
    DBLongIterator getIteratorForAddresses(Address start, Address end) throws IOException {
        return new AddressIndexKeyIterator(this.refTable, 1, this.addrMap, start, end, true);
    }

    @Override
    DBLongIterator getIteratorForAddresses(Address start) throws IOException {
        return new AddressIndexKeyIterator(this.refTable, 1, this.addrMap, start, true);
    }

    @Override
    DBLongIterator getIteratorForAddresses(AddressSetView set) throws IOException {
        return new AddressIndexKeyIterator(this.refTable, 1, this.addrMap, set, true);
    }

    @Override
    void removeRecord(long key) throws IOException {
        this.refTable.deleteRecord(key);
    }

    @Override
    RecordIterator getRecords() throws IOException {
        return this.refTable.iterator();
    }

    @Override
    void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws CancelledException, IOException {
        DatabaseTableUtils.updateIndexedAddressField(this.refTable, 1, this.addrMap, fromAddr, toAddr, length, null, monitor);
    }

    @Override
    int getRecordCount() {
        return this.refTable.getRecordCount();
    }
}

