/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.format.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.format.FieldHeader;
import ghidra.app.util.viewer.format.FieldHeaderLocation;
import ghidra.util.HelpLocation;

public class EnableFieldAction
extends DockingAction {
    private FieldHeaderLocation loc;
    private FieldHeader panel;

    public EnableFieldAction(String owner, FieldHeader panel) {
        super("Enable Field", owner, false);
        this.panel = panel;
        this.setPopupMenuData(new MenuData(new String[]{"Enable Field"}, null, "field"));
        this.setEnabled(true);
        this.setHelpLocation(new HelpLocation("CodeBrowserPlugin", "Enable Field"));
    }

    public boolean isEnabledForContext(ActionContext context) {
        Object contextObject = context.getContextObject();
        if (contextObject instanceof FieldHeaderLocation) {
            this.loc = (FieldHeaderLocation)contextObject;
            FieldFactory ff = this.loc.getFieldFactory();
            return ff != null && !ff.isEnabled();
        }
        return false;
    }

    public void actionPerformed(ActionContext context) {
        FieldFactory factory = this.loc.getFieldFactory();
        this.panel.setTabLock(true);
        factory.setEnabled(true);
    }
}

