/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.dwarf.DWARFCompilationUnit;
import ghidra.app.util.bin.format.dwarf.DWARFProgram;
import ghidra.app.util.bin.format.dwarf.DWARFRange;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFForm;
import ghidra.program.model.data.LEB128;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DWARFRangeList {
    public static final DWARFRangeList EMTPY = new DWARFRangeList(List.of());
    private List<DWARFRange> ranges;

    public static DWARFRangeList readV4(BinaryReader reader, DWARFCompilationUnit cu) throws IOException {
        long maxAddrVal;
        byte pointerSize = cu.getPointerSize();
        ArrayList<DWARFRange> ranges = new ArrayList<DWARFRange>();
        long baseAddress = cu.getPCRange().getFrom();
        long l = maxAddrVal = pointerSize == 4 ? 0xFFFFFFFFL : -1L;
        while (reader.hasNext()) {
            long beginning = reader.readNextUnsignedValue(pointerSize);
            long ending = reader.readNextUnsignedValue(pointerSize);
            if (beginning == 0L && ending == 0L) break;
            if (beginning == maxAddrVal) {
                baseAddress = ending;
                continue;
            }
            ranges.add(new DWARFRange(baseAddress + beginning, baseAddress + ending));
        }
        return new DWARFRangeList(ranges);
    }

    public static DWARFRangeList readV5(BinaryReader reader, DWARFCompilationUnit cu) throws IOException {
        int rleId;
        ArrayList<DWARFRange> list = new ArrayList<DWARFRange>();
        DWARFProgram dprog = cu.getProgram();
        long baseAddr = cu.getPCRange().getFrom();
        block9: while (reader.hasNext() && (rleId = reader.readNextUnsignedByte()) != 0) {
            switch (rleId) {
                case 1: {
                    int addrIndex = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
                    baseAddr = dprog.getAddress(DWARFForm.DW_FORM_addrx, addrIndex, cu);
                    continue block9;
                }
                case 2: {
                    int startAddrIndex = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
                    int endAddrIndex = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
                    long start = dprog.getAddress(DWARFForm.DW_FORM_addrx, startAddrIndex, cu);
                    long end = dprog.getAddress(DWARFForm.DW_FORM_addrx, endAddrIndex, cu);
                    list.add(new DWARFRange(start, end));
                    continue block9;
                }
                case 3: {
                    int startAddrIndex = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
                    int len = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
                    long start = dprog.getAddress(DWARFForm.DW_FORM_addrx, startAddrIndex, cu);
                    list.add(new DWARFRange(start, start + (long)len));
                    continue block9;
                }
                case 4: {
                    int startOfs = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
                    int endOfs = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
                    list.add(new DWARFRange(baseAddr + (long)startOfs, baseAddr + (long)endOfs));
                    continue block9;
                }
                case 5: {
                    baseAddr = reader.readNextUnsignedValue(cu.getPointerSize());
                    continue block9;
                }
                case 6: {
                    long startAddr = reader.readNextUnsignedValue(cu.getPointerSize());
                    long endAddr = reader.readNextUnsignedValue(cu.getPointerSize());
                    list.add(new DWARFRange(startAddr, endAddr));
                    continue block9;
                }
                case 7: {
                    long startAddr = reader.readNextUnsignedValue(cu.getPointerSize());
                    int len = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
                    list.add(new DWARFRange(startAddr, startAddr + (long)len));
                    continue block9;
                }
            }
            throw new IOException("Unsupported DWARF Range List Entry type: %d".formatted(rleId));
        }
        return new DWARFRangeList(list);
    }

    public DWARFRangeList(DWARFRange singleRange) {
        this.ranges = List.of(singleRange);
    }

    public DWARFRangeList(List<DWARFRange> ranges) {
        this.ranges = ranges;
    }

    public boolean isEmpty() {
        return this.ranges.isEmpty();
    }

    public long getFirstAddress() {
        return this.getFirst().getFrom();
    }

    public DWARFRange getFirst() {
        return this.ranges.get(0);
    }

    public DWARFRange get(int index) {
        return this.ranges.get(index);
    }

    public List<DWARFRange> ranges() {
        return this.ranges;
    }

    public int getListCount() {
        return this.ranges.size();
    }

    public DWARFRange getLast() {
        return this.ranges.get(this.ranges.size() - 1);
    }

    public DWARFRange getFlattenedRange() {
        if (this.isEmpty()) {
            return null;
        }
        if (this.ranges.size() == 1) {
            return this.getFirst();
        }
        ArrayList<DWARFRange> copy = new ArrayList<DWARFRange>(this.ranges);
        Collections.sort(copy);
        DWARFRange first = (DWARFRange)copy.get(0);
        DWARFRange last = (DWARFRange)copy.get(copy.size() - 1);
        return new DWARFRange(first.getFrom(), last.getTo());
    }

    public String toString() {
        return "DWARFRangeList: " + String.valueOf(this.ranges);
    }
}

