/*
 * Decompiled with CFR 0.152.
 */
package org.prevayler.foundation.serialization;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.prevayler.foundation.serialization.Serializer;

public class GZIPSerializer
implements Serializer {
    private final Serializer _delegate;
    private final int _bufferSize;

    public GZIPSerializer(Serializer delegate) {
        this(delegate, 512);
    }

    public GZIPSerializer(Serializer delegate, int gzipBufferSize) {
        this._delegate = delegate;
        this._bufferSize = gzipBufferSize;
    }

    @Override
    public void writeObject(OutputStream stream, Object object) throws Exception {
        GZIPOutputStream gzip = new GZIPOutputStream(stream, this._bufferSize);
        this._delegate.writeObject(gzip, object);
        gzip.close();
    }

    @Override
    public Object readObject(InputStream stream) throws Exception {
        GZIPInputStream gunzip = new GZIPInputStream(stream, this._bufferSize);
        return this._delegate.readObject(gunzip);
    }
}

