/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractSymbolInternals;

public class PublicSymbolInternals32
extends AbstractSymbolInternals {
    protected long offset;
    protected int segment;
    protected String name;
    protected long flags;
    protected boolean isCode;
    protected boolean isFunction;
    protected boolean isManaged;
    protected boolean isMicrosoftIntermediateLanguage;

    public static PublicSymbolInternals32 parse32(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        PublicSymbolInternals32 result = new PublicSymbolInternals32(pdb);
        long flags = reader.parseUnsignedIntVal();
        result.offset = reader.parseVarSizedOffset(32);
        result.segment = pdb.parseSegment(reader);
        result.name = reader.parseString(pdb, StringParseType.StringUtf8Nt);
        PublicSymbolInternals32.processFlags(result, flags);
        return result;
    }

    public static PublicSymbolInternals32 parse32St(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        PublicSymbolInternals32 result = new PublicSymbolInternals32(pdb);
        long flags = reader.parseUnsignedIntVal();
        result.offset = reader.parseVarSizedOffset(32);
        result.segment = pdb.parseSegment(reader);
        result.name = reader.parseString(pdb, StringParseType.StringUtf8St);
        PublicSymbolInternals32.processFlags(result, flags);
        return result;
    }

    public PublicSymbolInternals32(AbstractPdb pdb) {
        super(pdb);
    }

    public long getOffset() {
        return this.offset;
    }

    public int getSegment() {
        return this.segment;
    }

    public String getName() {
        return this.name;
    }

    public long getFlags() {
        return this.flags;
    }

    public boolean isCode() {
        return this.isCode;
    }

    public boolean isFunction() {
        return this.isFunction;
    }

    public boolean isManaged() {
        return this.isManaged;
    }

    public boolean isMicrosoftIntermediateLanguage() {
        return this.isMicrosoftIntermediateLanguage;
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(String.format(": [%04X:%08X], Flags: %08x, %s", this.segment, this.offset, this.flags, this.name));
    }

    private static void processFlags(PublicSymbolInternals32 internals, long flagsIn) {
        internals.flags = flagsIn;
        internals.isCode = (flagsIn & 1L) == 1L;
        internals.isFunction = ((flagsIn >>= 1) & 1L) == 1L;
        internals.isManaged = ((flagsIn >>= 1) & 1L) == 1L;
        internals.isMicrosoftIntermediateLanguage = ((flagsIn >>= 1) & 1L) == 1L;
    }
}

