/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data.exceptionhandling;

import ghidra.app.cmd.data.AbstractCreateDataBackgroundCmd;
import ghidra.app.cmd.data.EHDataTypeUtilities;
import ghidra.app.cmd.data.exceptionhandling.EHUnwindModel;
import ghidra.app.util.datatype.microsoft.DataApplyOptions;
import ghidra.app.util.datatype.microsoft.DataValidationOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;

public class CreateEHUnwindMapBackgroundCmd
extends AbstractCreateDataBackgroundCmd<EHUnwindModel> {
    public CreateEHUnwindMapBackgroundCmd(Address address, int count) {
        super("UnwindMapEntry", address, count);
    }

    public CreateEHUnwindMapBackgroundCmd(Address address, int count, DataValidationOptions validationOptions, DataApplyOptions applyOptions) {
        super("UnwindMapEntry", address, count, validationOptions, applyOptions);
    }

    CreateEHUnwindMapBackgroundCmd(EHUnwindModel unwindModel, DataApplyOptions applyOptions) {
        super(unwindModel, applyOptions);
    }

    @Override
    protected EHUnwindModel createModel(Program program) {
        if (this.model == null) {
            this.model = new EHUnwindModel(program, this.count, this.getDataAddress(), this.validationOptions);
        }
        return (EHUnwindModel)this.model;
    }

    @Override
    protected boolean createAssociatedData() throws CancelledException {
        return this.createActionRefsAndSymbols();
    }

    private boolean createActionRefsAndSymbols() throws CancelledException {
        this.monitor.setMessage("Creating Unwind action markup");
        boolean result = true;
        Program program = ((EHUnwindModel)this.model).getProgram();
        for (int unwindEntryOrdinal = 0; unwindEntryOrdinal < this.count; ++unwindEntryOrdinal) {
            boolean success;
            Address actionAddress;
            Address compAddress;
            this.monitor.checkCancelled();
            try {
                compAddress = ((EHUnwindModel)this.model).getComponentAddressOfActionAddress(unwindEntryOrdinal);
                actionAddress = ((EHUnwindModel)this.model).getActionAddress(unwindEntryOrdinal);
            }
            catch (InvalidDataTypeException e) {
                throw new AssertException((Throwable)e);
            }
            if (actionAddress == null) continue;
            if (this.applyOptions.shouldCreateLabel()) {
                try {
                    Symbol symbol = EHDataTypeUtilities.createSymbolIfNeeded(program, "Unwind", actionAddress);
                    if (symbol == null) {
                        result = false;
                    }
                }
                catch (InvalidInputException e) {
                    String message = "Couldn't create name for unwind action at " + actionAddress.toString() + ".";
                    this.handleErrorMessage(program, compAddress, message + " " + e.getMessage(), message);
                    result = false;
                }
            }
            if (!this.applyOptions.shouldCreateFunction() || (success = EHDataTypeUtilities.createFunctionIfNeeded(program, actionAddress))) continue;
            result = false;
        }
        return result;
    }

    @Override
    protected boolean createMarkup() throws CancelledException {
        return true;
    }
}

