/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.renderers;

import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.jgrapht.Graph;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.RenderContext;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.renderers.HeavyweightEdgeRenderer;
import org.jungrapht.visualization.renderers.Renderer;
import org.jungrapht.visualization.transform.LensTransformer;
import org.jungrapht.visualization.transform.MutableTransformer;
import org.jungrapht.visualization.transform.shape.TransformingGraphics;

public class ReshapingEdgeRenderer<V, E>
extends HeavyweightEdgeRenderer<V, E>
implements Renderer.Edge<V, E> {
    @Override
    protected void drawSimpleEdge(RenderContext<V, E> renderContext, LayoutModel<V> layoutModel, E e) {
        Paint draw_paint;
        LensTransformer ht;
        RectangularShape lensShape;
        TransformingGraphics g = (TransformingGraphics)renderContext.getGraphicsContext();
        Graph graph = layoutModel.getGraph();
        Object v1 = graph.getEdgeSource(e);
        Object v2 = graph.getEdgeTarget(e);
        Point p1 = (Point)layoutModel.apply(v1);
        Point p2 = (Point)layoutModel.apply(v2);
        Point2D p12d = renderContext.getMultiLayerTransformer().transform(MultiLayerTransformer.Layer.LAYOUT, p1.x, p1.y);
        Point2D p22d = renderContext.getMultiLayerTransformer().transform(MultiLayerTransformer.Layer.LAYOUT, p2.x, p2.y);
        float x1 = (float)p12d.getX();
        float y1 = (float)p12d.getY();
        float x2 = (float)p22d.getX();
        float y2 = (float)p22d.getY();
        float flatness = 0.0f;
        MutableTransformer transformer = renderContext.getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.VIEW);
        if (transformer instanceof LensTransformer && ((lensShape = (ht = (LensTransformer)transformer).getLens().getLensShape()).contains(x1, y1) || lensShape.contains(x2, y2))) {
            flatness = 0.05f;
        }
        boolean isLoop = v1.equals(v2);
        Shape s2 = renderContext.getVertexShapeFunction().apply(v2);
        Shape edgeShape = renderContext.getEdgeShapeFunction().apply(graph, e);
        AffineTransform xform = AffineTransform.getTranslateInstance(x1, y1);
        if (isLoop) {
            Rectangle2D s2Bounds = s2.getBounds2D();
            xform.scale(s2Bounds.getWidth(), s2Bounds.getHeight());
            xform.translate(0.0, -edgeShape.getBounds2D().getWidth() / 2.0);
        } else {
            float dx = x2 - x1;
            float dy = y2 - y1;
            float thetaRadians = (float)Math.atan2(dy, dx);
            xform.rotate(thetaRadians);
            float dist = (float)Math.sqrt(dx * dx + dy * dy);
            xform.scale(dist, 1.0);
        }
        edgeShape = xform.createTransformedShape(edgeShape);
        Paint oldPaint = g.getPaint();
        Paint fill_paint = renderContext.getEdgeFillPaintFunction().apply(e);
        if (fill_paint != null) {
            g.setPaint(fill_paint);
            g.fill(edgeShape, flatness);
        }
        if ((draw_paint = renderContext.getEdgeDrawPaintFunction().apply(e)) != null) {
            g.setPaint(draw_paint);
            g.draw(edgeShape, flatness);
        }
        float scalex = (float)g.getTransform().getScaleX();
        float scaley = (float)g.getTransform().getScaleY();
        if ((double)scalex < 0.3 || (double)scaley < 0.3) {
            return;
        }
        if (renderContext.renderEdgeArrow()) {
            Shape destVertexShape = renderContext.getVertexShapeFunction().apply(v2);
            AffineTransform xf = AffineTransform.getTranslateInstance(x2, y2);
            destVertexShape = xf.createTransformedShape(destVertexShape);
            AffineTransform at = this.edgeArrowRenderingSupport.getArrowTransform(renderContext, new GeneralPath(edgeShape), destVertexShape);
            if (at == null) {
                return;
            }
            Shape arrow = renderContext.getEdgeArrow();
            arrow = at.createTransformedShape(arrow);
            g.setPaint(renderContext.getArrowFillPaintFunction().apply(e));
            g.fill(arrow);
            g.setPaint(renderContext.getArrowDrawPaintFunction().apply(e));
            g.draw(arrow);
            if (!graph.getType().isDirected()) {
                Shape vertexShape = renderContext.getVertexShapeFunction().apply(v1);
                xf = AffineTransform.getTranslateInstance(x1, y1);
                vertexShape = xf.createTransformedShape(vertexShape);
                at = this.edgeArrowRenderingSupport.getReverseArrowTransform(renderContext, new GeneralPath(edgeShape), vertexShape, !isLoop);
                if (at == null) {
                    return;
                }
                arrow = renderContext.getEdgeArrow();
                arrow = at.createTransformedShape(arrow);
                g.setPaint(renderContext.getArrowFillPaintFunction().apply(e));
                g.fill(arrow);
                g.setPaint(renderContext.getArrowDrawPaintFunction().apply(e));
                g.draw(arrow);
            }
        }
        if (draw_paint == null) {
            g.setPaint(oldPaint);
        }
        g.setPaint(oldPaint);
    }
}

