/*
 * Decompiled with CFR 0.152.
 */
package ghidra.sleigh.grammar;

import ghidra.sleigh.grammar.LineArrayListWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.BufferedTreeNodeStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;

public class ANTLRUtil {
    static String indent(int n) {
        StringBuilder sb = new StringBuilder();
        for (int ii = 0; ii < n; ++ii) {
            sb.append("    ");
        }
        return sb.toString();
    }

    public static void debugNodeStream(BufferedTreeNodeStream nodes, PrintStream out) {
        Iterator iterator = nodes.iterator();
        int indent = 0;
        while (iterator.hasNext()) {
            Object object = iterator.next();
            CommonTree node = (CommonTree)object;
            Token token = node.token;
            if (token != null) {
                if (token.getType() == 2) {
                    ++indent;
                    continue;
                }
                if (token.getType() == 3) {
                    --indent;
                    continue;
                }
            }
            String line = token == null ? "no pos" : token.getLine() + ":" + token.getCharPositionInLine();
            out.println(ANTLRUtil.indent(indent) + "'" + String.valueOf(object) + "'     (" + line + ")");
        }
    }

    public static void debugTokenStream(CommonTokenStream tokens, PrintStream out) {
        List list = tokens.getTokens();
        Iterator iterator = list.iterator();
        int ii = -1;
        while (iterator.hasNext()) {
            Object object = iterator.next();
            out.println(String.valueOf(object) + "     (" + ++ii + ")");
        }
    }

    public static void debugTree(Tree tree, PrintStream out) {
        ANTLRUtil.debugNodeStream(new BufferedTreeNodeStream((Object)tree), out);
    }

    public static String getLine(Reader reader, int lineno) throws IOException {
        BufferedReader buf = new BufferedReader(reader);
        String line = null;
        while (lineno > 0) {
            line = buf.readLine();
            --lineno;
        }
        return line;
    }

    public static String getLine(LineArrayListWriter writer, int lineno) throws IOException {
        int line;
        int size = writer.getLines().size();
        for (line = StrictMath.min(writer.getLines().size() - 1, lineno - 1); line < 0; line += size) {
        }
        return writer.getLines().get(line);
    }

    public static String generateArrow(int charPositionInLine) {
        StringBuilder sb = new StringBuilder();
        while (charPositionInLine > 0) {
            sb.append("-");
            --charPositionInLine;
        }
        sb.append("^");
        return sb.toString();
    }

    public static int tabCompensate(String line, int charPositionInLine) {
        if (charPositionInLine < 0) {
            return charPositionInLine;
        }
        int pos = 0;
        char[] cs = new char[charPositionInLine];
        line.getChars(0, charPositionInLine, cs, 0);
        for (int ii = 0; ii < charPositionInLine; ++ii) {
            if (cs[ii] == '\t') {
                pos = (pos + 8) / 8 * 8;
                continue;
            }
            ++pos;
        }
        return pos;
    }
}

