/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.code;

import db.DBRecord;
import db.RecordIterator;
import ghidra.program.database.code.CodeManager;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import java.io.IOException;
import java.util.Iterator;

public class InstructionRecordIterator
implements InstructionIterator {
    private CodeManager codeMgr;
    private RecordIterator it;
    private Instruction nextInstruction;
    private boolean forward;

    public InstructionRecordIterator(CodeManager codeMgr, RecordIterator it, boolean forward) {
        this.codeMgr = codeMgr;
        this.it = it;
        this.forward = forward;
    }

    @Override
    public boolean hasNext() {
        if (this.nextInstruction == null) {
            this.findNext();
        }
        return this.nextInstruction != null;
    }

    @Override
    public Instruction next() {
        if (this.hasNext()) {
            Instruction ret = this.nextInstruction;
            this.nextInstruction = null;
            return ret;
        }
        return null;
    }

    private void findNext() {
        try {
            while (this.nextInstruction == null && (this.forward ? this.it.hasNext() : this.it.hasPrevious())) {
                DBRecord record = this.forward ? this.it.next() : this.it.previous();
                this.nextInstruction = this.codeMgr.getInstructionDB(record);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Instruction> iterator() {
        return this;
    }
}

