/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.wizard.add;

import docking.wizard.WizardModel;
import docking.wizard.WizardStep;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.wizard.add.AddToSessionData;
import ghidra.feature.vt.gui.wizard.add.AddToSessionTask;
import ghidra.feature.vt.gui.wizard.add.AddressSetOptionsStep;
import ghidra.feature.vt.gui.wizard.add.CorrelatorChooserStep;
import ghidra.feature.vt.gui.wizard.add.LimitAddressSetsStep;
import ghidra.feature.vt.gui.wizard.add.OptionsStep;
import ghidra.feature.vt.gui.wizard.add.SummaryStep;
import ghidra.program.model.listing.Program;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import java.awt.Component;
import java.util.List;

public class VTAddToSessionWizardModel
extends WizardModel<AddToSessionData> {
    private final VTController controller;

    public VTAddToSessionWizardModel(VTController controller) {
        super("Add to Version Tracking Session", (Object)new AddToSessionData());
        this.controller = controller;
        Program sourceProgram = controller.getSourceProgram();
        Program destinationProgram = controller.getDestinationProgram();
        VTSession session = controller.getSession();
        ((AddToSessionData)this.data).setSourceProgram(sourceProgram);
        ((AddToSessionData)this.data).setDestinationProgram(destinationProgram);
        ((AddToSessionData)this.data).setSession(session);
        ((AddToSessionData)this.data).setSourceSelection(controller.getSelectionInSourceTool());
        ((AddToSessionData)this.data).setDestinationSelection(controller.getSelectionInDestinationTool());
    }

    protected void addWizardSteps(List<WizardStep<AddToSessionData>> list) {
        list.add(new CorrelatorChooserStep(this, this.controller.getSession()));
        list.add(new OptionsStep(this));
        list.add(new AddressSetOptionsStep(this));
        list.add(new LimitAddressSetsStep(this, this.controller.getTool()));
        list.add(new SummaryStep(this));
    }

    protected boolean doFinish() {
        AddToSessionTask task = new AddToSessionTask(this.controller, (AddToSessionData)this.data);
        new TaskLauncher((Task)task, (Component)this.wizardDialog.getComponent());
        return true;
    }
}

