/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.squashfs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.squashfs.SquashFragment;
import ghidra.file.formats.squashfs.SquashSuperBlock;
import ghidra.file.formats.squashfs.SquashUtils;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SquashFragmentTable {
    private final List<SquashFragment> fragmentEntries;
    private long minFragPointer = Long.MAX_VALUE;

    public SquashFragmentTable(BinaryReader reader, SquashSuperBlock superBlock, TaskMonitor monitor) throws IOException, CancelledException {
        monitor.checkCancelled();
        reader.setPointerIndex(superBlock.getFragmentTableStart());
        this.fragmentEntries = new ArrayList<SquashFragment>();
        long numFragments = (superBlock.getTotalFragments() * 16L + 8192L - 1L) / 8192L;
        long[] fragmentPointers = reader.readNextLongArray((int)numFragments);
        for (int i = 0; i < fragmentPointers.length; ++i) {
            monitor.checkCancelled();
            this.minFragPointer = Math.min(this.minFragPointer, fragmentPointers[i]);
            reader.setPointerIndex(fragmentPointers[i]);
            byte[] uncompressedBytes = SquashUtils.decompressBlock(reader, superBlock.getCompressionType(), monitor);
            BinaryReader fragmentReader = SquashUtils.byteArrayToReader(uncompressedBytes);
            while (fragmentReader.hasNext()) {
                monitor.checkCancelled();
                this.fragmentEntries.add(new SquashFragment(fragmentReader));
            }
        }
    }

    public List<SquashFragment> getFragments() {
        return this.fragmentEntries;
    }

    public SquashFragment getFragment(int index) {
        if (index >= 0 && index < this.fragmentEntries.size()) {
            return this.fragmentEntries.get(index);
        }
        return null;
    }

    public long getMinFragPointer() {
        return this.minFragPointer;
    }
}

