/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.img3;

import ghidra.file.formats.ios.img3.Img3Constants;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import java.util.Arrays;

public final class Img3Util {
    public static final boolean isIMG3(Program program) {
        Address address;
        if (program != null && (address = program.getMinAddress()) != null) {
            byte[] bytes = new byte[4];
            try {
                program.getMemory().getBytes(address, bytes);
            }
            catch (MemoryAccessException memoryAccessException) {
                // empty catch block
            }
            return Arrays.equals(bytes, Img3Constants.IMG3_SIGNATURE_BYTES);
        }
        return false;
    }
}

