/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationHandler;
import ghidra.app.util.bin.format.elf.relocation.PIC30_ElfRelocationHandler;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import java.util.Map;

class PIC30_ElfRelocationContext
extends ElfRelocationContext<PIC30_ElfRelocationHandler> {
    protected PIC30_ElfRelocationContext(PIC30_ElfRelocationHandler handler, ElfLoadHelper loadHelper, Map<ElfSymbol, Address> symbolMap) {
        super((ElfRelocationHandler)handler, loadHelper, symbolMap);
    }

    private boolean isDebugSection(AddressSpace overlaySpace) {
        String name = overlaySpace.getName();
        return name.startsWith(".debug_") || ".comment".equals(name);
    }

    public Address getRelocationAddress(Address baseAddress, long relocOffset) {
        if (!baseAddress.isLoadedMemoryAddress() && this.isDebugSection(baseAddress.getAddressSpace())) {
            relocOffset >>= 1;
        }
        return baseAddress.addWrap(relocOffset);
    }
}

