/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.xml;

import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationTable;
import ghidra.util.XmlProgramUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.XmlAttributes;
import ghidra.util.xml.XmlUtilities;
import ghidra.util.xml.XmlWriter;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXParseException;

class RelocationTableXmlMgr {
    private Program program;
    private MessageLog log;

    RelocationTableXmlMgr(Program program, MessageLog log) {
        this.program = program;
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void read(XmlPullParser parser, TaskMonitor monitor) throws SAXParseException, CancelledException {
        RelocationTable relocTable = this.program.getRelocationTable();
        AddressFactory factory = this.program.getAddressFactory();
        XmlElement element = parser.next();
        while (true) {
            monitor.checkCancelled();
            element = parser.next();
            if (!element.getName().equals("RELOCATION")) return;
            try {
                String addrStr = element.getAttribute("ADDRESS");
                if (addrStr == null) {
                    this.log.appendMsg("relocation address not specified.");
                    continue;
                }
                Address addr = XmlProgramUtilities.parseAddress((AddressFactory)factory, (String)addrStr);
                if (addr == null) {
                    throw new AddressFormatException("Incompatible Relocation Address: " + addrStr);
                }
                int type = XmlUtilities.parseInt((String)element.getAttribute("TYPE"));
                long[] values = this.unpackLongs(element.getAttribute("VALUE"));
                byte[] bytes = this.unpackBytes(element.getAttribute("BYTES"));
                String symbolName = element.getAttribute("SYMBOL_NAME");
                String statusAttr = element.getAttribute("STATUS");
                Relocation.Status status = Relocation.Status.UNKNOWN;
                if (statusAttr != null) {
                    try {
                        status = Relocation.Status.valueOf((String)statusAttr.toUpperCase());
                    }
                    catch (IllegalArgumentException e) {
                        throw new SAXParseException("Invalid relocation status: " + statusAttr, null, null, parser.getLineNumber(), parser.getColumnNumber());
                    }
                }
                if (bytes == null) {
                    if (status != null && status.hasBytes()) {
                        this.log.appendMsg("Relocation at " + addrStr + " missing required bytes - forced UNKNOWN status.");
                        status = Relocation.Status.UNKNOWN;
                    }
                } else if (status == null) {
                    status = type == 0 ? Relocation.Status.APPLIED_OTHER : Relocation.Status.APPLIED;
                }
                relocTable.add(addr, status, type, values, bytes, symbolName);
                continue;
            }
            catch (Exception e) {
                this.log.appendException((Throwable)e);
                continue;
            }
            finally {
                element = parser.next();
                continue;
            }
            break;
        }
    }

    private long[] unpackLongs(String attrValue) {
        if (attrValue == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(attrValue, ",");
        long[] values = new long[st.countTokens()];
        int index = 0;
        while (st.hasMoreTokens()) {
            values[index++] = XmlUtilities.parseLong((String)st.nextToken());
        }
        return values;
    }

    private byte[] unpackBytes(String attrValue) {
        if (attrValue == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(attrValue, ",");
        byte[] values = new byte[st.countTokens()];
        int index = 0;
        while (st.hasMoreTokens()) {
            values[index++] = (byte)XmlUtilities.parseInt((String)st.nextToken());
        }
        return values;
    }

    private String pack(long[] values) {
        if (values == null || values.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (long v : values) {
            if (buf.length() != 0) {
                buf.append(',');
            }
            buf.append("0x" + Long.toHexString(v));
        }
        return buf.toString();
    }

    private String pack(byte[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        for (byte v : values) {
            if (buf.length() != 0) {
                buf.append(',');
            }
            buf.append("0x" + Integer.toHexString(v & 0xFF));
        }
        return buf.toString();
    }

    void write(XmlWriter writer, TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Writing RELOCATION TABLE ...");
        writer.startElement("RELOCATION_TABLE");
        Iterator iter = this.program.getRelocationTable().getRelocations();
        while (iter.hasNext()) {
            String symName;
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            Relocation reloc = (Relocation)iter.next();
            XmlAttributes attrs = new XmlAttributes();
            attrs.addAttribute("ADDRESS", XmlProgramUtilities.toString((Address)reloc.getAddress()));
            attrs.addAttribute("TYPE", reloc.getType(), true);
            attrs.addAttribute("VALUE", this.pack(reloc.getValues()));
            String packedBytes = this.pack(reloc.getBytes());
            if (packedBytes != null) {
                attrs.addAttribute("BYTES", packedBytes);
            }
            if (!StringUtils.isEmpty((CharSequence)(symName = reloc.getSymbolName()))) {
                attrs.addAttribute("SYMBOL_NAME", reloc.getSymbolName());
            }
            writer.startElement("RELOCATION", attrs);
            writer.endElement("RELOCATION");
        }
        writer.endElement("RELOCATION_TABLE");
    }
}

