/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.reloc;

import ghidra.app.plugin.core.reloc.RelocationFixupHandler;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationType;
import java.util.HashMap;
import java.util.Map;

public abstract class ElfRelocationFixupHandler
extends RelocationFixupHandler {
    private Map<Integer, ElfRelocationType> relocationTypesMap;

    protected ElfRelocationFixupHandler(Class<? extends ElfRelocationType> relocationEnumClass) {
        this.initRelocationTypeMap(relocationEnumClass);
    }

    private void initRelocationTypeMap(Class<? extends ElfRelocationType> relocationEnumClass) {
        if (!relocationEnumClass.isEnum() || !ElfRelocationType.class.isAssignableFrom(relocationEnumClass)) {
            throw new IllegalArgumentException("Invalid class specified - expected enum which implements ElfRelocationType: " + relocationEnumClass.getName());
        }
        this.relocationTypesMap = new HashMap<Integer, ElfRelocationType>();
        for (ElfRelocationType t : relocationEnumClass.getEnumConstants()) {
            this.relocationTypesMap.put(t.typeId(), t);
        }
    }

    public ElfRelocationType getRelocationType(int type) {
        if (this.relocationTypesMap == null) {
            return null;
        }
        return this.relocationTypesMap.get(type);
    }
}

