/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.disassembler;

import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.PseudoDisassembler;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.options.Options;
import ghidra.program.disassemble.Disassembler;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.lang.AddressLabelInfo;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.util.AddressSetPropertyMap;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.program.model.util.ProcessorSymbolType;
import ghidra.util.HelpLocation;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class EntryPointAnalyzer
extends AbstractAnalyzer {
    public static final String NAME = "Disassemble Entry Points";
    private static final String DESCRIPTION = "Disassembles entry points in newly added memory.";
    private static final String OPTION_NAME_RESPECT_EXECUTE_FLAG = "Respect Execute Flag";
    private static final String OPTION_DESCRIPTION_RESPECT_EXECUTE_FLAG = "Respect Execute flag on memory blocks when checking entry points for code.";
    private static final boolean OPTION_DEFAULT_RESPECT_EXECUTE_ENABLED = true;
    private boolean respectExecuteFlags = true;
    private AddressSetView executeSet;

    public EntryPointAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setPriority(AnalysisPriority.BLOCK_ANALYSIS);
        this.setDefaultEnablement(true);
    }

    @Override
    public void registerOptions(Options options, Program program) {
        HelpLocation helpLocation = new HelpLocation("AutoAnalysisPlugin", "Auto_Analysis_Option_Instructions");
        options.registerOption(OPTION_NAME_RESPECT_EXECUTE_FLAG, (Object)this.respectExecuteFlags, helpLocation, OPTION_DESCRIPTION_RESPECT_EXECUTE_FLAG);
    }

    @Override
    public void optionsChanged(Options options, Program program) {
        this.respectExecuteFlags = options.getBoolean(OPTION_NAME_RESPECT_EXECUTE_FLAG, this.respectExecuteFlags);
    }

    @Override
    public boolean added(Program program, AddressSetView addressSet, TaskMonitor monitor, MessageLog log) throws CancelledException {
        monitor.initialize(addressSet.getNumAddresses());
        HashSet<Address> doNowSet = new HashSet<Address>();
        HashSet<Address> doLaterSet = new HashSet<Address>();
        this.executeSet = program.getMemory().getExecuteSet();
        if (!this.executeSet.isEmpty()) {
            addressSet = addressSet.intersect(this.executeSet);
        }
        this.disassembleCodeMapMarkers(program, monitor);
        HashSet<Address> dummyFunctionSet = new HashSet<Address>();
        HashSet<Address> redoFunctionSet = new HashSet<Address>();
        this.findDummyFunctions(program, addressSet, dummyFunctionSet, redoFunctionSet);
        this.doDisassembly(program, monitor, dummyFunctionSet);
        this.addCodeSymbolsToSet(program, addressSet, monitor, doNowSet);
        int externalCount = this.addExternalSymbolsToSet(program, addressSet, monitor, doNowSet);
        if (!this.isSingleExternalEntryPoint(program, externalCount, doNowSet)) {
            this.moveSuspectSymbolsToDoLaterSet(program, monitor, doNowSet, doLaterSet);
        }
        this.doDisassembly(program, monitor, doNowSet);
        this.checkDoLaterSet(program, monitor, doLaterSet);
        this.processDoLaterSet(program, monitor, doLaterSet);
        this.fixDummyFunctionBodies(program, monitor, redoFunctionSet);
        return true;
    }

    private void processDoLaterSet(Program program, TaskMonitor monitor, Set<Address> doLaterSet) {
        if (doLaterSet.isEmpty()) {
            return;
        }
        if (this.getPriority() == AnalysisPriority.BLOCK_ANALYSIS) {
            AutoAnalysisManager analysisManager = AutoAnalysisManager.getAnalysisManager(program);
            EntryPointAnalyzer entryPointAnalyzer = new EntryPointAnalyzer();
            entryPointAnalyzer.setPriority(AnalysisPriority.REFERENCE_ANALYSIS.before());
            analysisManager.scheduleOneTimeAnalysis(entryPointAnalyzer, this.toAddressSet(doLaterSet));
        } else {
            this.doDisassembly(program, monitor, doLaterSet);
        }
    }

    private boolean isSingleExternalEntryPoint(Program program, int externalCount, Set<Address> doNowSet) {
        SymbolTable symbolTable = program.getSymbolTable();
        return externalCount == 1 && doNowSet.size() == 1 && symbolTable.getPrimarySymbol(doNowSet.iterator().next()).isExternalEntryPoint();
    }

    private AddressSetView toAddressSet(Set<Address> doLaterSet) {
        AddressSet set = new AddressSet();
        for (Address address : doLaterSet) {
            set.add(address);
        }
        return set;
    }

    private void fixDummyFunctionBodies(Program program, TaskMonitor monitor, Set<Address> redoFunctionSet) throws CancelledException {
        Function function;
        HashSet<Address> recreateFunctionSet = new HashSet<Address>();
        for (Address entry : redoFunctionSet) {
            Function func;
            Reference reference;
            Instruction instr;
            function = program.getFunctionManager().getFunctionAt(entry);
            if (function == null || (instr = program.getListing().getInstructionAt(entry)) == null) continue;
            ReferenceIterator referencesTo = program.getReferenceManager().getReferencesTo(entry);
            boolean foundNonJumpRef = false;
            while (referencesTo.hasNext()) {
                reference = referencesTo.next();
                if (reference.getReferenceType().isJump()) continue;
                foundNonJumpRef = true;
                break;
            }
            if (!foundNonJumpRef) {
                Address[] functionThunkAddresses = function.getFunctionThunkAddresses();
                boolean bl = foundNonJumpRef = functionThunkAddresses != null && functionThunkAddresses.length != 0;
            }
            if (function.getSymbol().isExternalEntryPoint() || foundNonJumpRef) {
                recreateFunctionSet.add(entry);
                continue;
            }
            referencesTo = program.getReferenceManager().getReferencesTo(entry);
            while (referencesTo.hasNext()) {
                reference = referencesTo.next();
                func = program.getFunctionManager().getFunctionContaining(reference.getFromAddress());
                if (func == null) continue;
                recreateFunctionSet.add(func.getEntryPoint());
            }
            Address fallFrom = instr.getFallFrom();
            if (fallFrom != null && (func = program.getFunctionManager().getFunctionContaining(fallFrom)) != null) {
                recreateFunctionSet.add(func.getEntryPoint());
            }
            recreateFunctionSet.add(entry);
        }
        for (Address entry : recreateFunctionSet) {
            function = program.getFunctionManager().getFunctionAt(entry);
            CreateFunctionCmd.fixupFunctionBody(program, function, monitor);
        }
    }

    private void checkDoLaterSet(Program program, TaskMonitor monitor, Set<Address> doLaterSet) throws CancelledException {
        PseudoDisassembler pdis = new PseudoDisassembler(program);
        pdis.setRespectExecuteFlag(this.respectExecuteFlags);
        Listing listing = program.getListing();
        Iterator<Address> laterIter = doLaterSet.iterator();
        while (laterIter.hasNext()) {
            Address entry = laterIter.next();
            monitor.checkCancelled();
            if (!listing.isUndefined(entry, entry)) {
                laterIter.remove();
                continue;
            }
            if (program.getRelocationTable().hasRelocation(entry)) {
                laterIter.remove();
                continue;
            }
            boolean isValid = pdis.isValidSubroutine(entry, true, false);
            if (isValid) continue;
            laterIter.remove();
        }
    }

    private void moveSuspectSymbolsToDoLaterSet(Program program, TaskMonitor monitor, Set<Address> doNowSet, Set<Address> doLaterSet) throws CancelledException {
        PseudoDisassembler pdis = new PseudoDisassembler(program);
        int count = 0;
        monitor.initialize((long)doNowSet.size());
        Listing listing = program.getListing();
        SymbolTable symbolTable = program.getSymbolTable();
        HashSet<Address> indirectSet = new HashSet<Address>();
        Iterator<Address> iter = doNowSet.iterator();
        while (iter.hasNext()) {
            Address entry = iter.next();
            monitor.setProgress((long)count++);
            monitor.checkCancelled();
            if (!listing.isUndefined(entry, entry)) {
                iter.remove();
                continue;
            }
            Symbol symbol = symbolTable.getPrimarySymbol(entry);
            if (!symbol.isExternalEntryPoint()) {
                iter.remove();
                doLaterSet.add(entry);
                continue;
            }
            if (this.isLanguageDefinedEntry(program, entry)) {
                if (!this.isLanguageDefinedEntryPointer(program, entry)) continue;
                Address newLoc = this.layDownCodePointer(program, entry);
                if (newLoc != null) {
                    indirectSet.add(newLoc);
                }
                iter.remove();
                continue;
            }
            if (this.isLanguageDefinedEntry(program, entry) || pdis.isValidSubroutine(entry)) continue;
            doLaterSet.add(entry);
            iter.remove();
        }
        doNowSet.addAll(indirectSet);
    }

    private Address layDownCodePointer(Program program, Address entry) {
        int defaultPointerSize = program.getDefaultPointerSize();
        try {
            Address codeLoc;
            Data data = program.getListing().createData(entry, (DataType)PointerDataType.getPointer(null, (int)defaultPointerSize));
            Object value = data.getValue();
            if (value instanceof Address && (codeLoc = (Address)value).getOffset() != 0L) {
                PseudoDisassembler.setTargetContextForDisassembly((Program)program, (Address)codeLoc);
                int instructionAlignment = program.getLanguage().getInstructionAlignment();
                if (codeLoc.getOffset() % (long)instructionAlignment != 0L) {
                    codeLoc = codeLoc.subtract(codeLoc.getOffset() % (long)instructionAlignment);
                }
                return codeLoc;
            }
        }
        catch (CodeUnitInsertionException codeUnitInsertionException) {
            // empty catch block
        }
        return null;
    }

    private int addExternalSymbolsToSet(Program program, AddressSetView addressSet, TaskMonitor monitor, Set<Address> set) throws CancelledException {
        int externalCount = 0;
        SymbolTable symbolTable = program.getSymbolTable();
        AddressIterator aiter = program.getSymbolTable().getExternalEntryPointIterator();
        while (aiter.hasNext()) {
            ++externalCount;
            monitor.checkCancelled();
            Address entryAddr = aiter.next();
            Symbol entry = symbolTable.getPrimarySymbol(entryAddr);
            if (!addressSet.contains(entryAddr) || entry.getSource() != SourceType.DEFAULT) continue;
            set.add(entryAddr);
        }
        return externalCount;
    }

    private void addCodeSymbolsToSet(Program program, AddressSetView addressSet, TaskMonitor monitor, Set<Address> set) throws CancelledException {
        SymbolTable symbolTable = program.getSymbolTable();
        SymbolIterator symbolIter = symbolTable.getSymbols(addressSet, SymbolType.LABEL, true);
        while (symbolIter.hasNext()) {
            monitor.checkCancelled();
            Symbol entry = symbolIter.next();
            Address entryAddr = entry.getAddress();
            if (!addressSet.contains(entryAddr)) continue;
            set.add(entryAddr);
        }
    }

    private void disassembleCodeMapMarkers(Program program, TaskMonitor monitor) {
        AddressSetPropertyMap codeProp = program.getAddressSetPropertyMap("CodeMap");
        if (codeProp != null) {
            HashSet<Address> codeSet = new HashSet<Address>();
            AddressIterator aiter = codeProp.getAddresses();
            while (aiter.hasNext()) {
                codeSet.add(aiter.next());
            }
            this.doDisassembly(program, monitor, codeSet);
        }
    }

    private void findDummyFunctions(Program program, AddressSetView set, Set<Address> dummyFunctionSet, Set<Address> redoFunctionSet) {
        FunctionIterator functions = program.getFunctionManager().getFunctions(set, true);
        while (functions.hasNext()) {
            Function function = (Function)functions.next();
            Address entryPoint = function.getEntryPoint();
            AddressSetView body = function.getBody();
            if (body == null || program.getListing().getDefinedDataAt(entryPoint) != null) continue;
            if (body.getNumAddresses() == 1L) {
                redoFunctionSet.add(entryPoint);
            }
            if (program.getListing().getInstructionAt(entryPoint) != null) continue;
            dummyFunctionSet.add(entryPoint);
        }
    }

    private boolean isLanguageDefinedEntry(Program program, Address addr) {
        List labelList = program.getLanguage().getDefaultSymbols();
        for (AddressLabelInfo info : labelList) {
            if (!addr.equals((Object)info.getAddress())) continue;
            return info.isEntry();
        }
        return false;
    }

    private boolean isLanguageDefinedEntryPointer(Program program, Address addr) {
        List labelList = program.getLanguage().getDefaultSymbols();
        for (AddressLabelInfo info : labelList) {
            if (!addr.equals((Object)info.getAddress())) continue;
            ProcessorSymbolType type = info.getProcessorSymbolType();
            return type != null && type.equals((Object)ProcessorSymbolType.CODE_PTR);
        }
        return false;
    }

    private void doDisassembly(Program program, TaskMonitor monitor, Set<Address> entries) {
        if (entries.isEmpty()) {
            return;
        }
        Iterator<Address> iter = entries.iterator();
        AddressSet disSet = new AddressSet();
        while (iter.hasNext()) {
            Address entry = iter.next();
            disSet.addRange(entry, entry);
        }
        Disassembler dis = Disassembler.getDisassembler((Program)program, (TaskMonitor)monitor, null);
        AddressSet disassembledSet = dis.disassemble((AddressSetView)disSet, null, true);
        AutoAnalysisManager.getAnalysisManager(program).codeDefined((AddressSetView)disassembledSet);
        AddressSet functionEntries = new AddressSet();
        Listing listing = program.getListing();
        for (Address addr : entries) {
            Symbol s;
            if (listing.getInstructionAt(addr) == null || (s = program.getSymbolTable().getPrimarySymbol(addr)) == null || !s.isExternalEntryPoint() || listing.getFunctionContaining(addr) != null) continue;
            functionEntries.addRange(addr, addr);
        }
        if (!functionEntries.isEmpty()) {
            CreateFunctionCmd createFunctionCmd = new CreateFunctionCmd((AddressSetView)functionEntries);
            createFunctionCmd.applyTo(program, monitor);
        }
    }
}

