/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph.layout.flowchart;

import ghidra.app.plugin.core.functiongraph.graph.layout.flowchart.EdgeSegment;
import ghidra.app.plugin.core.functiongraph.graph.layout.flowchart.EdgeSegmentMap;
import ghidra.app.plugin.core.functiongraph.graph.layout.flowchart.OrthogonalGridSizer;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.layout.GridCoordinates;
import ghidra.graph.viewer.layout.GridLocationMap;
import ghidra.graph.viewer.layout.GridPoint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class OrthogonalGridToLayoutMapper<V extends VisualVertex, E extends VisualEdge<V>> {
    private static final int EDGE_SPACING = 7;
    private static final int CONDENSED_EDGE_SPACING = 5;
    private EdgeSegmentMap<E> segmentMap;
    private GridLocationMap<V, E> grid;
    private Function<V, Shape> transformer;
    private GridCoordinates gridCoordinates;
    private int edgeSpacing;

    public OrthogonalGridToLayoutMapper(GridLocationMap<V, E> grid, Function<V, Shape> transformer, boolean isCondensed) {
        this.grid = grid;
        this.transformer = transformer;
        this.edgeSpacing = isCondensed ? 5 : 7;
        this.segmentMap = new EdgeSegmentMap<E>(grid);
        OrthogonalGridSizer<V, E> sizer = new OrthogonalGridSizer<V, E>(grid, this.segmentMap, transformer, this.edgeSpacing);
        this.gridCoordinates = sizer.getGridCoordinates(isCondensed);
    }

    public Map<V, Point2D> getVertexLocations() {
        HashMap<VisualVertex, Point2D.Double> vertexLocations = new HashMap<VisualVertex, Point2D.Double>();
        for (Map.Entry entry : this.grid.getVertexPoints().entrySet()) {
            VisualVertex v = (VisualVertex)entry.getKey();
            GridPoint p = (GridPoint)entry.getValue();
            Shape shape = this.transformer.apply(v);
            Rectangle vertexBounds = shape.getBounds();
            int x = this.gridCoordinates.x(p.col);
            int y = this.gridCoordinates.y(p.row) + (vertexBounds.height >> 1);
            Point2D.Double location = new Point2D.Double(x, y);
            vertexLocations.put(v, location);
        }
        return vertexLocations;
    }

    public Map<E, List<Point2D>> getEdgeLocations(Map<V, Point2D> vertexLocations) {
        HashMap edgeLocations = new HashMap();
        for (VisualEdge edge : this.grid.edges()) {
            List gridPoints = this.grid.getArticulations((Object)edge);
            ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>(gridPoints.size());
            GridPoint gp = (GridPoint)gridPoints.get(0);
            EdgeSegment edgeSegment = this.segmentMap.getColumnSegment(edge, gp);
            int offset = edgeSegment.getOffset();
            double x = this.gridCoordinates.x(gp.col) + offset * this.edgeSpacing;
            double y = vertexLocations.get(edge.getStart()).getY();
            points.add(new Point2D.Double(x, y));
            for (int i = 1; i < gridPoints.size() - 1; ++i) {
                edgeSegment = edgeSegment.nextSegment();
                gp = (GridPoint)gridPoints.get(i);
                if (i % 2 == 0) {
                    offset = edgeSegment.getOffset();
                    x = this.gridCoordinates.x(gp.col) + offset * this.edgeSpacing;
                    points.add(new Point2D.Double(x, y));
                    continue;
                }
                offset = edgeSegment.getOffset();
                y = this.gridCoordinates.y(gp.row) + offset * this.edgeSpacing;
                points.add(new Point2D.Double(x, y));
            }
            gp = (GridPoint)gridPoints.get(gridPoints.size() - 1);
            y = vertexLocations.get(edge.getEnd()).getY();
            points.add(new Point2D.Double(x, y));
            edgeLocations.put(edge, points);
        }
        return edgeLocations;
    }

    public GridCoordinates getGridCoordinates() {
        return this.gridCoordinates;
    }

    public List<Integer> getEdgeOffsets(E edge) {
        ArrayList<Integer> offsets = new ArrayList<Integer>();
        List gridPoints = this.grid.getArticulations(edge);
        GridPoint gp = (GridPoint)gridPoints.get(0);
        for (EdgeSegment edgeSegment = this.segmentMap.getColumnSegment(edge, gp); edgeSegment != null; edgeSegment = ((EdgeSegment)edgeSegment).nextSegment()) {
            offsets.add(edgeSegment.getOffset());
        }
        return offsets;
    }

    public void dispose() {
        this.segmentMap.dispose();
        this.grid.dispose();
        this.gridCoordinates = null;
    }
}

