/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph.layout.flowchart;

import ghidra.app.plugin.core.functiongraph.graph.layout.flowchart.EdgeSegment;
import ghidra.app.plugin.core.functiongraph.graph.layout.flowchart.RowSegment;
import ghidra.graph.viewer.layout.GridPoint;
import java.util.List;

public class ColumnSegment<E>
extends EdgeSegment<E> {
    private RowSegment<E> next;
    private RowSegment<E> previous;

    public ColumnSegment(E e, List<GridPoint> points) {
        this(null, e, points, 0);
    }

    ColumnSegment(RowSegment<E> previous, E e, List<GridPoint> points, int pointIndex) {
        super(e, points, pointIndex);
        this.previous = previous;
        if (pointIndex < points.size() - 2) {
            this.next = new RowSegment<E>(this, e, points, pointIndex + 1);
        }
    }

    public int getCol() {
        return ((GridPoint)this.points.get((int)this.pointIndex)).col;
    }

    public int getStartRow() {
        return ((GridPoint)this.points.get((int)this.pointIndex)).row;
    }

    public int getEndRow() {
        return ((GridPoint)this.points.get((int)(this.pointIndex + 1))).row;
    }

    public int compareToIgnoreFlows(ColumnSegment<E> other) {
        int result = this.compareTops(other);
        if (result == 0) {
            result = this.compareBottoms(other);
        }
        return result;
    }

    public int compareToUsingFlows(ColumnSegment<E> other) {
        if (this.isFlowingUpwards()) {
            int result = this.compareBottoms(other);
            if (result == 0) {
                result = this.compareTops(other);
            }
            return result;
        }
        int result = this.compareTops(other);
        if (result == 0) {
            result = this.compareBottoms(other);
        }
        return result;
    }

    public int compareTops(ColumnSegment<E> other) {
        RowOrientation otherTopRowOrientation;
        int result = this.getCol() - other.getCol();
        if (result != 0) {
            return result;
        }
        RowOrientation myTopRowOrientation = this.getOrientationForTopRow();
        if (myTopRowOrientation != (otherTopRowOrientation = other.getOrientationForTopRow())) {
            return myTopRowOrientation.compareTo(otherTopRowOrientation);
        }
        switch (myTopRowOrientation.ordinal()) {
            case 0: {
                RowSegment<E> myTopRowSegment = this.getTopRowSegment();
                RowSegment<E> otherTopRowSegment = other.getTopRowSegment();
                return -myTopRowSegment.compareLefts(otherTopRowSegment);
            }
            case 2: {
                RowSegment<E> myTopRowSegment = this.getTopRowSegment();
                RowSegment<E> otherTopRowSegment = other.getTopRowSegment();
                return myTopRowSegment.compareRights(otherTopRowSegment);
            }
        }
        return 0;
    }

    public int compareBottoms(ColumnSegment<E> other) {
        RowOrientation otherTopRowOrientation;
        int result = this.getCol() - other.getCol();
        if (result != 0) {
            return result;
        }
        RowOrientation myBottomRowOrientation = this.getOrientationForBottomRow();
        if (myBottomRowOrientation != (otherTopRowOrientation = other.getOrientationForBottomRow())) {
            return myBottomRowOrientation.compareTo(otherTopRowOrientation);
        }
        switch (myBottomRowOrientation.ordinal()) {
            case 0: {
                RowSegment<E> myBottomRowSegment = this.getBottomRowSegment();
                RowSegment<E> otherBottomRowSegment = other.getBottomRowSegment();
                return myBottomRowSegment.compareLefts(otherBottomRowSegment);
            }
            case 2: {
                RowSegment<E> myBottomRowSegment = this.getBottomRowSegment();
                RowSegment<E> otherBottomRowSegment = other.getBottomRowSegment();
                return -myBottomRowSegment.compareRights(otherBottomRowSegment);
            }
        }
        return 0;
    }

    public boolean overlaps(ColumnSegment<E> other) {
        if (this.getVirtualMinY() > other.getVirtualMaxY()) {
            return false;
        }
        return this.getVirtualMaxY() >= other.getVirtualMinY();
    }

    @Override
    public RowSegment<E> nextSegment() {
        return this.next;
    }

    @Override
    public RowSegment<E> previousSegment() {
        return this.previous;
    }

    public boolean isStartSegment() {
        return this.previous == null;
    }

    public boolean isEndSegment() {
        return this.next == null;
    }

    public int getVirtualMinY() {
        return Math.min(this.getVirtualStartY(), this.getVirtualEndY());
    }

    public int getVirtualMaxY() {
        return Math.max(this.getVirtualStartY(), this.getVirtualEndY());
    }

    private int getVirtualStartY() {
        int offset = this.previous == null ? 1 : this.previous.getOffset();
        return this.getStartRow() * 1000000 + offset;
    }

    private int getVirtualEndY() {
        int offset = this.next == null ? -1 : this.next.getOffset();
        return this.getEndRow() * 1000000 + offset;
    }

    private RowSegment<E> getTopRowSegment() {
        return this.isFlowingUpwards() ? this.next : this.previous;
    }

    private RowSegment<E> getBottomRowSegment() {
        return this.isFlowingUpwards() ? this.previous : this.next;
    }

    private RowOrientation getOrientationForTopRow() {
        if (this.isStartSegment()) {
            return RowOrientation.TERMINAL;
        }
        RowSegment<E> topRowSegment = this.getTopRowSegment();
        int topRowOtherCol = this.isFlowingUpwards() ? topRowSegment.getEndCol() : topRowSegment.getStartCol();
        return topRowOtherCol < this.getCol() ? RowOrientation.LEFT : RowOrientation.RIGHT;
    }

    private RowOrientation getOrientationForBottomRow() {
        if (this.isEndSegment()) {
            return RowOrientation.TERMINAL;
        }
        RowSegment<E> bottomRowSegment = this.getBottomRowSegment();
        int bottomRowOtherCol = this.isFlowingUpwards() ? bottomRowSegment.getStartCol() : bottomRowSegment.getEndCol();
        return bottomRowOtherCol < this.getCol() ? RowOrientation.LEFT : RowOrientation.RIGHT;
    }

    public boolean isFlowingUpwards() {
        return this.getStartRow() > this.getEndRow();
    }

    public ColumnSegment<E> last() {
        if (this.isEndSegment()) {
            return this;
        }
        return this.next.last();
    }

    static enum RowOrientation {
        LEFT,
        TERMINAL,
        RIGHT;

    }
}

