/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.struct;

import ghidra.pcode.struct.AssignStmt;
import ghidra.pcode.struct.Expr;
import ghidra.pcode.struct.LValInternal;
import ghidra.pcode.struct.RValInternal;
import ghidra.pcode.struct.StringTree;
import ghidra.pcode.struct.StructuredSleigh;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;

class DerefExpr
extends Expr
implements LValInternal {
    private final AddressSpace space;
    private final RValInternal addr;

    private DerefExpr(StructuredSleigh ctx, AddressSpace space, RValInternal addr, DataType type) {
        super(ctx, type);
        this.space = space;
        this.addr = addr;
    }

    protected DerefExpr(StructuredSleigh ctx, AddressSpace space, RValInternal addr) {
        this(ctx, space, addr, ctx.computeDerefType(addr));
    }

    @Override
    public StructuredSleigh.LVal cast(DataType type) {
        return new DerefExpr(this.ctx, this.space, this.addr, type);
    }

    public String toString() {
        return "<Deref *" + String.valueOf(this.addr) + ">";
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public StringTree generate(RValInternal parent) {
        st = new StringTree();
        if (!(parent instanceof AssignStmt)) ** GOTO lbl-1000
        as = (AssignStmt)parent;
        if (as.lhs == this) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        v1 = useParens = v0 == false;
        if (useParens) {
            st.append("(*");
        } else {
            st.append("*");
        }
        if (this.ctx.language.getDefaultSpace() != this.space) {
            st.append("[");
            st.append(this.space.getName());
            st.append("]");
        }
        if (this.type.getLength() != 0) {
            st.append(":");
            st.append(Integer.toString(this.type.getLength()));
        }
        st.append(" ");
        st.append(this.addr.generate(this));
        if (useParens) {
            st.append(")");
        }
        return st;
    }
}

