/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.replace;

import ghidra.features.base.quickfix.QuickFix;
import ghidra.features.base.replace.SearchAndReplaceHandler;
import ghidra.features.base.replace.SearchType;
import ghidra.program.model.listing.Program;
import ghidra.util.UserSearchUtils;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class SearchAndReplaceQuery {
    private final String searchText;
    private final String replacementText;
    private final Pattern pattern;
    private final int searchLimit;
    private final Set<SearchType> selectedTypes = new HashSet<SearchType>();

    public SearchAndReplaceQuery(String searchText, String replacementText, Set<SearchType> searchTypes, boolean isRegEx, boolean isCaseSensitive, boolean isWholeWord, int searchLimit) {
        this.searchText = searchText;
        this.replacementText = replacementText;
        this.pattern = this.createPattern(isRegEx, isCaseSensitive, isWholeWord);
        this.searchLimit = searchLimit;
        this.selectedTypes.addAll(searchTypes);
    }

    public void findAll(Program program, Accumulator<QuickFix> accumulator, TaskMonitor monitor) throws CancelledException {
        Set<SearchAndReplaceHandler> handlers = this.getHandlers();
        for (SearchAndReplaceHandler handler : handlers) {
            handler.findAll(program, this, accumulator, monitor);
        }
    }

    public Pattern getSearchPattern() {
        return this.pattern;
    }

    public boolean containsSearchType(SearchType searchType) {
        return this.selectedTypes.contains(searchType);
    }

    public String getSearchText() {
        return this.searchText;
    }

    public String getReplacementText() {
        return this.replacementText;
    }

    public Set<SearchType> getSelectedSearchTypes() {
        return this.selectedTypes;
    }

    public int getSearchLimit() {
        return this.searchLimit;
    }

    private Pattern createPattern(boolean isRegEx, boolean isCaseSensitive, boolean isWholeWord) {
        int regExFlags = 32;
        if (!isCaseSensitive) {
            regExFlags |= 2;
        }
        if (isRegEx) {
            return Pattern.compile(this.searchText, regExFlags);
        }
        Object converted = UserSearchUtils.convertUserInputToRegex((String)this.searchText, (boolean)false);
        if (isWholeWord) {
            converted = "\\b" + (String)converted + "\\b";
        }
        return Pattern.compile((String)converted, regExFlags);
    }

    private Set<SearchAndReplaceHandler> getHandlers() {
        HashSet<SearchAndReplaceHandler> handlers = new HashSet<SearchAndReplaceHandler>();
        for (SearchType type : this.selectedTypes) {
            handlers.add(type.getHandler());
        }
        return handlers;
    }
}

