/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.dyld;

import ghidra.app.util.bin.BinaryReader;
import java.io.IOException;

public class DyldChainedPtr {
    public static final int DYLD_CHAINED_PTR_START_NONE = 65535;
    public static final int DYLD_CHAINED_PTR_START_MULTI = 32768;
    public static final int DYLD_CHAINED_PTR_START_LAST = 32768;

    public static long getStride(DyldChainType ptrFormat) {
        return switch (ptrFormat.ordinal()) {
            case 1, 2, 3, 4, 5, 6, 7, 9 -> 4L;
            case 0, 8, 11, 12 -> 8L;
            default -> 1L;
        };
    }

    public static int getSize(DyldChainType ptrFormat) {
        return switch (ptrFormat.ordinal()) {
            case 2, 3, 4 -> 4;
            default -> 8;
        };
    }

    public static long getChainValue(BinaryReader reader, long chainLoc, DyldChainType ptrFormat) throws IOException {
        return switch (ptrFormat.ordinal()) {
            case 2, 3, 4 -> reader.readUnsignedInt(chainLoc);
            case 0, 1, 5, 6, 7, 8, 9, 10, 11, 12 -> reader.readLong(chainLoc);
            default -> 0L;
        };
    }

    public static boolean isRelative(DyldChainType ptrFormat) {
        return switch (ptrFormat.ordinal()) {
            case 5, 6, 7, 8, 10, 11, 12 -> true;
            default -> false;
        };
    }

    public static boolean isBound(DyldChainType ptrFormat, long chainValue) {
        return switch (ptrFormat.ordinal()) {
            case 0, 6, 8, 11 -> {
                if ((chainValue >>> 62 & 1L) != 0L) {
                    yield true;
                }
                yield false;
            }
            case 1, 5 -> {
                if ((chainValue >>> 63 & 1L) != 0L) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if ((chainValue >>> 31 & 1L) != 0L) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public static boolean isAuthenticated(DyldChainType ptrFormat, long chainValue) {
        return switch (ptrFormat.ordinal()) {
            case 1, 2, 3, 4, 5 -> false;
            default -> (chainValue >>> 63 & 1L) != 0L;
        };
    }

    public static long getTarget(DyldChainType ptrFormat, long chainValue) {
        if (DyldChainedPtr.isBound(ptrFormat, chainValue)) {
            return -1L;
        }
        if (DyldChainedPtr.isAuthenticated(ptrFormat, chainValue)) {
            switch (ptrFormat.ordinal()) {
                case 0: 
                case 6: 
                case 8: 
                case 11: {
                    return chainValue & 0xFFFFFFFFL;
                }
                case 7: 
                case 10: {
                    return chainValue & 0x3FFFFFFFL;
                }
                case 12: {
                    return chainValue & 0x3FFFFFFFFL;
                }
            }
        }
        return switch (ptrFormat.ordinal()) {
            case 0, 6, 8, 11 -> {
                long top8Bits = chainValue >> 43 & 0xFFL;
                long bottom43Bits = chainValue & 0x7FFFFFFFFFFL;
                if (top8Bits == 128L) {
                    top8Bits = 0L;
                }
                yield top8Bits << 56 | bottom43Bits;
            }
            case 1, 5 -> {
                long top8Bits = chainValue >> 36 & 0xFFL;
                long bottom36Bits = chainValue & 0xFFFFFFFFFL;
                if (top8Bits == 128L) {
                    top8Bits = 0L;
                }
                yield top8Bits << 56 | bottom36Bits;
            }
            case 2 -> chainValue & 0x3FFFFFL;
            case 3 -> chainValue & 0x3FFFFFFFL;
            case 4 -> chainValue & 0x3FFFFFL;
            case 7, 10 -> chainValue & 0x3FFFFFFFL;
            case 12 -> chainValue & 0x3FFFFFFFFL;
            default -> 0L;
        };
    }

    public static long getAddend(DyldChainType ptrFormat, long chainValue) {
        if (!DyldChainedPtr.isBound(ptrFormat, chainValue)) {
            return 0L;
        }
        return switch (ptrFormat.ordinal()) {
            case 0, 8, 11 -> {
                long addend = chainValue >>> 32 & 0x7FFFFL;
                yield addend = (addend & 0x40000L) != 0L ? addend | 0xFFFFFFFFFFFC0000L : addend;
            }
            case 1, 5 -> chainValue >>> 24 & 0xFFL;
            case 2 -> chainValue >>> 20 & 0x3FL;
            default -> 0L;
        };
    }

    public static long getOrdinal(DyldChainType ptrFormat, long chainValue) {
        if (!DyldChainedPtr.isBound(ptrFormat, chainValue)) {
            return -1L;
        }
        return switch (ptrFormat.ordinal()) {
            case 0, 6, 8 -> chainValue & 0xFFFFL;
            case 1, 5, 11 -> chainValue & 0xFFFFFFL;
            case 2 -> chainValue & 0xFFFFFL;
            default -> -1L;
        };
    }

    public static long getNext(DyldChainType ptrFormat, long chainValue) {
        return switch (ptrFormat.ordinal()) {
            case 0, 6, 8, 11 -> chainValue >>> 51 & 0x7FFL;
            case 1, 5, 7, 10 -> chainValue >>> 51 & 0xFFFL;
            case 2 -> chainValue >>> 26 & 0x1FL;
            case 9 -> 0L;
            case 3 -> chainValue >>> 30 & 3L;
            case 4 -> chainValue >>> 26 & 0x3FL;
            case 12 -> chainValue >>> 52 & 0x7FFL;
            default -> 1L;
        };
    }

    public static enum DyldChainType {
        DYLD_CHAINED_PTR_ARM64E(1),
        DYLD_CHAINED_PTR_64(2),
        DYLD_CHAINED_PTR_32(3),
        DYLD_CHAINED_PTR_32_CACHE(4),
        DYLD_CHAINED_PTR_32_FIRMWARE(5),
        DYLD_CHAINED_PTR_64_OFFSET(6),
        DYLD_CHAINED_PTR_ARM64E_KERNEL(7),
        DYLD_CHAINED_PTR_64_KERNEL_CACHE(8),
        DYLD_CHAINED_PTR_ARM64E_USERLAND(9),
        DYLD_CHAINED_PTR_ARM64E_FIRMWARE(10),
        DYLD_CHAINED_PTR_X86_64_KERNEL_CACHE(11),
        DYLD_CHAINED_PTR_ARM64E_USERLAND24(12),
        DYLD_CHAINED_PTR_ARM64E_SHARED_CACHE(13),
        DYLD_CHAINED_PTR_TYPE_UNKNOWN(-1);

        private final int val;
        private final String name;

        private DyldChainType(int v) {
            this.val = v;
            this.name = this.name().substring("DYLD_CHAINED_".length());
        }

        public static DyldChainType lookupChainPtr(int val) {
            return switch (val) {
                case 1 -> DYLD_CHAINED_PTR_ARM64E;
                case 2 -> DYLD_CHAINED_PTR_64;
                case 3 -> DYLD_CHAINED_PTR_32;
                case 4 -> DYLD_CHAINED_PTR_32_CACHE;
                case 5 -> DYLD_CHAINED_PTR_32_FIRMWARE;
                case 6 -> DYLD_CHAINED_PTR_64_OFFSET;
                case 7 -> DYLD_CHAINED_PTR_ARM64E_KERNEL;
                case 8 -> DYLD_CHAINED_PTR_64_KERNEL_CACHE;
                case 9 -> DYLD_CHAINED_PTR_ARM64E_USERLAND;
                case 10 -> DYLD_CHAINED_PTR_ARM64E_FIRMWARE;
                case 11 -> DYLD_CHAINED_PTR_X86_64_KERNEL_CACHE;
                case 12 -> DYLD_CHAINED_PTR_ARM64E_USERLAND24;
                case 13 -> DYLD_CHAINED_PTR_ARM64E_SHARED_CACHE;
                default -> DYLD_CHAINED_PTR_TYPE_UNKNOWN;
            };
        }

        public int getValue() {
            return this.val;
        }

        public String getName() {
            return this.name;
        }
    }
}

