/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import docking.action.KeyBindingData;
import generic.theme.GIcon;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.app.plugin.core.compositeeditor.CompositeViewerDataTypeManager;
import javax.swing.Icon;

public class UndoChangeAction
extends CompositeEditorTableAction {
    public static String DESCRIPTION = "Undo Change";
    public static final String ACTION_NAME = "Undo Editor Change";
    private static final String GROUP_NAME = "1_UNDOREDO_EDITOR_ACTION";
    private static final Icon ICON = new GIcon("icon.undo");
    private static final String[] POPUP_PATH = new String[]{DESCRIPTION};

    public UndoChangeAction(CompositeEditorProvider<?, ?> provider) {
        super(provider, ACTION_NAME, GROUP_NAME, POPUP_PATH, null, ICON);
        this.setKeyBindingData(new KeyBindingData("ctrl Z"));
        this.setDescription(DESCRIPTION);
    }

    public void actionPerformed(ActionContext context) {
        if (!this.isEnabledForContext(context)) {
            return;
        }
        CompositeViewerDataTypeManager viewDTM = this.model.getViewDataTypeManager();
        viewDTM.undo();
        this.model.clearStatus();
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (this.hasIncompleteFieldEntry()) {
            return false;
        }
        CompositeViewerDataTypeManager viewDTM = this.model.getViewDataTypeManager();
        boolean canUndo = viewDTM.canUndo();
        this.setEnabled(canUndo);
        String description = DESCRIPTION + (String)(canUndo ? ": " + viewDTM.getUndoName() : "");
        this.setDescription(description);
        return canUndo;
    }
}

