/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompiler.taint.slicetree;

import docking.widgets.tree.GTreeNode;
import generic.theme.GIcon;
import ghidra.app.plugin.core.decompiler.taint.slicetree.SliceNode;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.util.ProgramLocation;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;

public class LeafSliceNode
extends SliceNode {
    private static final Icon ICON = new GIcon("icon.plugin.calltree.node.dead.end");
    private final Reference reference;
    private String name;
    private final Program program;

    LeafSliceNode(Program program, Reference reference) {
        super(new AtomicInteger(0));
        this.program = program;
        this.reference = reference;
    }

    @Override
    public SliceNode recreate() {
        return new LeafSliceNode(this.program, this.reference);
    }

    @Override
    public Function getRemoteFunction() {
        return null;
    }

    @Override
    public Address getSourceAddress() {
        return this.reference.getFromAddress();
    }

    public Icon getIcon(boolean expanded) {
        return ICON;
    }

    public String getName() {
        if (this.name == null) {
            Address toAddress = this.reference.getToAddress();
            SymbolTable symbolTable = this.program.getSymbolTable();
            Symbol symbol = symbolTable.getPrimarySymbol(toAddress);
            this.name = symbol != null ? symbol.getName() : toAddress.toString();
        }
        return this.name;
    }

    public String getToolTip() {
        return "Called from " + String.valueOf(this.reference.getFromAddress());
    }

    public boolean isLeaf() {
        return true;
    }

    @Override
    public ProgramLocation getLocation() {
        return new ProgramLocation(this.program, this.reference.getToAddress());
    }

    public List<GTreeNode> generateChildren(TaskMonitor monitor) throws CancelledException {
        return new ArrayList<GTreeNode>();
    }
}

