/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen;

import ghidra.pcode.emu.jit.analysis.JitAllocationModel;
import ghidra.pcode.emu.jit.gen.GenConsts;
import ghidra.pcode.emu.jit.gen.InstanceFieldReq;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.program.model.address.Address;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public record FieldForArrDirect(Address address) implements InstanceFieldReq
{
    @Override
    public String name() {
        return "arrDir_%s_%x".formatted(this.address.getAddressSpace().getName(), this.address.getOffset());
    }

    @Override
    public void generateInitCode(JitCodeGenerator gen, ClassVisitor cv, MethodVisitor iv) {
        cv.visitField(18, this.name(), GenConsts.TDESC_BYTE_ARR, null, null);
        JitAllocationModel.InitFixedLocal.THIS.generateLoadCode(iv);
        gen.generateLoadJitStateSpace(this.address.getAddressSpace(), iv);
        iv.visitLdcInsn((Object)this.address.getOffset());
        iv.visitMethodInsn(182, GenConsts.NAME_JIT_BYTES_PCODE_EXECUTOR_STATE_SPACE, "getDirect", GenConsts.MDESC_JIT_BYTES_PCODE_EXECUTOR_STATE_SPACE__GET_DIRECT, false);
        iv.visitFieldInsn(181, gen.nameThis, this.name(), GenConsts.TDESC_BYTE_ARR);
    }

    @Override
    public void generateLoadCode(JitCodeGenerator gen, MethodVisitor rv) {
        JitAllocationModel.RunFixedLocal.THIS.generateLoadCode(rv);
        rv.visitFieldInsn(180, gen.nameThis, this.name(), GenConsts.TDESC_BYTE_ARR);
    }
}

