/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import java.util.HashMap;
import java.util.Map;

public class HighLevelShaderLanguageMsType
extends AbstractMsType {
    public static final int PDB_ID = 5399;
    private RecordNumber subtypeRecordNumber;
    private Kind kind;
    private int numNumericProperties;
    private byte[] data;

    public HighLevelShaderLanguageMsType(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.subtypeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 32);
        this.kind = Kind.fromValue(reader.parseUnsignedShortVal());
        this.numNumericProperties = reader.parseUnsignedShortVal() & 0xF;
        this.data = reader.parseBytesRemaining();
    }

    @Override
    public int getPdbId() {
        return 5399;
    }

    public RecordNumber getSubtypeRecordNumber() {
        return this.subtypeRecordNumber;
    }

    public Kind getKind() {
        return this.kind;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        builder.append("Built-In HLSL: ");
        builder.append((Object)this.kind);
        builder.append(String.format(" <numProperties=%d>", this.numNumericProperties));
    }

    public static enum Kind {
        INVALID("invalid", -1),
        INTERFACE_POINTER("InterfacePointer", 512),
        TEXTURE_1D("Texture1D", 513),
        TEXTURE_1D_ARRAY("Texture1DArray", 514),
        TEXTURE_2D("Texture2D", 515),
        TEXTURE_2D_ARRAY("Texture2DArray", 516),
        TEXTURE_3D("Texture3D", 517),
        TEXTURE_CUBE("TextureCube", 518),
        TEXTURE_CUBE_ARRAY("TextureCubeArray", 519),
        TEXTURE_2D_MS("Texture2DMs", 520),
        TEXTURE_2D_MS_ARRAY("Texture2DMsArray", 521),
        SAMPLER("Sampler", 522),
        SAMPLER_COMPARISON("SamplerComparison", 523),
        BUFFER("Buffer", 524),
        POINT_STREAM("PointStream", 525),
        LINE_STREAM("LineStream", 526),
        TRIANGLE_STREAM("TriangleStream", 527),
        INPUT_PATCH("InputPatch", 528),
        OUTPUT_PATCH("OutputPatch", 529),
        RW_TEXTURE_1D("RwTexture1D", 530),
        RW_TEXTURE_1D_ARRAY("RwTexture1DArray", 531),
        RW_TEXTURE_2D("RwTexture2D", 532),
        RW_TEXTURE_2D_ARRAY("RwTexture2DArray", 533),
        RW_TEXTURE_3D("RwTexture3D", 534),
        RW_BUFFER("RwBuffer", 535),
        BYTE_ADDRESS_BUFFER("ByteAddressBuffer", 536),
        RW_BYTE_ADDRESS_BUFFER("RwByteAddressBuffer", 537),
        STRUCTURED_BUFFER("StructuredBuffer", 538),
        RW_STRUCTURED_BUFFER("RwStructuredBuffer", 539),
        APPEND_STRUCTURED_BUFFER("AppendStructuredBuffer", 540),
        CONSUME_STRUCTURED_BUFFER("ConsumeStructuredBuffer", 541),
        MIN_8FLOAT("Min8Float", 542),
        MIN_10FLOAT("Min10Float", 543),
        MIN_16FLOAT("Min16Float", 544),
        MIN_12INT("Min12Int", 545),
        MIN_16INT("Min16Int", 546),
        MIN_16UINT("Min16UInt", 547);

        private static final Map<Integer, Kind> BY_VALUE;
        public final String label;
        public final int value;

        public String toString() {
            return this.label;
        }

        public static Kind fromValue(int val) {
            return BY_VALUE.getOrDefault(val, INVALID);
        }

        private Kind(String label, int value) {
            this.label = label;
            this.value = value;
        }

        static {
            BY_VALUE = new HashMap<Integer, Kind>();
            for (Kind val : Kind.values()) {
                BY_VALUE.put(val.value, val);
            }
        }
    }
}

