/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import ghidra.util.bean.GGlassPane;
import ghidra.util.bean.GGlassPanePainter;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class ZoomedImagePainter
implements GGlassPanePainter {
    private Rectangle targetBounds;
    private Image image;
    private float zoom = 0.0f;
    private float magnifyFactor = 10.0f;

    public ZoomedImagePainter(Rectangle targetBounds, Image image) {
        this.targetBounds = targetBounds;
        this.image = image;
    }

    public void paint(GGlassPane glassPane, Graphics g) {
        if (this.image == null || this.targetBounds == null) {
            return;
        }
        int imageWidth = this.image.getWidth(null);
        int width = imageWidth + (int)((float)imageWidth * this.magnifyFactor * this.getZoom());
        int imageHeight = this.image.getHeight(null);
        int height = imageHeight + (int)((float)imageHeight * this.magnifyFactor * this.getZoom());
        int middleBoundsX = this.targetBounds.width >> 1;
        int middleBoundsY = this.targetBounds.height >> 1;
        int middleWidthX = width >> 1;
        int middleHeightY = height >> 1;
        int x = middleBoundsX - middleWidthX + this.targetBounds.x;
        int y = middleBoundsY - middleHeightY + this.targetBounds.y;
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        float alpha = 1.0f - this.zoom;
        g2.setComposite(AlphaComposite.getInstance(AlphaComposite.SrcOver.getRule(), alpha));
        g2.drawImage(this.image, x, y, width, height, null);
    }

    public float getZoom() {
        return this.zoom;
    }

    public void setZoom(float zoom) {
        this.zoom = zoom;
    }

    public Rectangle getTargetBounds() {
        return this.targetBounds;
    }

    public void setTargetBounds(Rectangle containerBounds) {
        this.targetBounds = containerBounds;
    }

    public void setMagnifyFactor(float factor) {
        this.magnifyFactor = factor;
    }

    public static Image createIconImage(Icon icon) {
        BufferedImage buffImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics graphics = buffImage.getGraphics();
        icon.paintIcon(null, graphics, 0, 0);
        graphics.dispose();
        return buffImage;
    }
}

